/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.BatchDeleteResponse;
import org.projectnessie.objectstoragemock.s3.DeletedS3Object;
import org.projectnessie.objectstoragemock.s3.ErrorObj;

@Generated(from="BatchDeleteResponse", generator="Immutables")
public final class ImmutableBatchDeleteResponse
implements BatchDeleteResponse {
    private final List<DeletedS3Object> deletedObjects;
    private final List<ErrorObj> errors;

    private ImmutableBatchDeleteResponse(List<DeletedS3Object> deletedObjects, List<ErrorObj> errors) {
        this.deletedObjects = deletedObjects;
        this.errors = errors;
    }

    @Override
    @JsonProperty(value="Deleted")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<DeletedS3Object> deletedObjects() {
        return this.deletedObjects;
    }

    @Override
    @JsonProperty(value="Error")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<ErrorObj> errors() {
        return this.errors;
    }

    public final ImmutableBatchDeleteResponse withDeletedObjects(DeletedS3Object ... elements) {
        List<DeletedS3Object> newValue = ImmutableBatchDeleteResponse.createUnmodifiableList(false, ImmutableBatchDeleteResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBatchDeleteResponse(newValue, this.errors);
    }

    public final ImmutableBatchDeleteResponse withDeletedObjects(Iterable<? extends DeletedS3Object> elements) {
        if (this.deletedObjects == elements) {
            return this;
        }
        List<DeletedS3Object> newValue = ImmutableBatchDeleteResponse.createUnmodifiableList(false, ImmutableBatchDeleteResponse.createSafeList(elements, true, false));
        return new ImmutableBatchDeleteResponse(newValue, this.errors);
    }

    public final ImmutableBatchDeleteResponse withErrors(ErrorObj ... elements) {
        List<ErrorObj> newValue = ImmutableBatchDeleteResponse.createUnmodifiableList(false, ImmutableBatchDeleteResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBatchDeleteResponse(this.deletedObjects, newValue);
    }

    public final ImmutableBatchDeleteResponse withErrors(Iterable<? extends ErrorObj> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<ErrorObj> newValue = ImmutableBatchDeleteResponse.createUnmodifiableList(false, ImmutableBatchDeleteResponse.createSafeList(elements, true, false));
        return new ImmutableBatchDeleteResponse(this.deletedObjects, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchDeleteResponse && this.equalsByValue((ImmutableBatchDeleteResponse)another);
    }

    private boolean equalsByValue(ImmutableBatchDeleteResponse another) {
        return this.deletedObjects.equals(another.deletedObjects) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.deletedObjects.hashCode();
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return "BatchDeleteResponse{deletedObjects=" + String.valueOf(this.deletedObjects) + ", errors=" + String.valueOf(this.errors) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBatchDeleteResponse fromJson(Json json) {
        Builder builder = ImmutableBatchDeleteResponse.builder();
        if (json._deletedObjects != null) {
            builder.addAllDeletedObjects(json._deletedObjects);
        }
        if (json._errors != null) {
            builder.addAllErrors(json._errors);
        }
        return builder.build();
    }

    public static ImmutableBatchDeleteResponse copyOf(BatchDeleteResponse instance) {
        if (instance instanceof ImmutableBatchDeleteResponse) {
            return (ImmutableBatchDeleteResponse)instance;
        }
        return ImmutableBatchDeleteResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BatchDeleteResponse", generator="Immutables")
    public static final class Builder {
        private List<DeletedS3Object> deletedObjects = new ArrayList<DeletedS3Object>();
        private List<ErrorObj> errors = new ArrayList<ErrorObj>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BatchDeleteResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDeletedObjects(instance.deletedObjects());
            this.addAllErrors(instance.errors());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletedObjects(DeletedS3Object element) {
            this.deletedObjects.add(Objects.requireNonNull(element, "deletedObjects element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletedObjects(DeletedS3Object ... elements) {
            for (DeletedS3Object element : elements) {
                this.deletedObjects.add(Objects.requireNonNull(element, "deletedObjects element"));
            }
            return this;
        }

        @JsonProperty(value="Deleted")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder deletedObjects(Iterable<? extends DeletedS3Object> elements) {
            this.deletedObjects.clear();
            return this.addAllDeletedObjects(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeletedObjects(Iterable<? extends DeletedS3Object> elements) {
            for (DeletedS3Object deletedS3Object : elements) {
                this.deletedObjects.add(Objects.requireNonNull(deletedS3Object, "deletedObjects element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(ErrorObj element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(ErrorObj ... elements) {
            for (ErrorObj element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        @JsonProperty(value="Error")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder errors(Iterable<? extends ErrorObj> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllErrors(Iterable<? extends ErrorObj> elements) {
            for (ErrorObj errorObj : elements) {
                this.errors.add(Objects.requireNonNull(errorObj, "errors element"));
            }
            return this;
        }

        public ImmutableBatchDeleteResponse build() {
            return new ImmutableBatchDeleteResponse(ImmutableBatchDeleteResponse.createUnmodifiableList(true, this.deletedObjects), ImmutableBatchDeleteResponse.createUnmodifiableList(true, this.errors));
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="BatchDeleteResponse", generator="Immutables")
    static final class Json
    implements BatchDeleteResponse {
        @JsonIgnore
        List<DeletedS3Object> _deletedObjects = Collections.emptyList();
        @JsonIgnore
        List<ErrorObj> _errors = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="Deleted")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setDeletedObjects(List<DeletedS3Object> deletedObjects) {
            this._deletedObjects = deletedObjects;
        }

        @JsonProperty(value="Error")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setErrors(List<ErrorObj> errors) {
            this._errors = errors;
        }

        @Override
        public List<DeletedS3Object> deletedObjects() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ErrorObj> errors() {
            throw new UnsupportedOperationException();
        }
    }
}

