/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.gcs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.gcs.ErrorResponse;

@Generated(from="ErrorResponse", generator="Immutables")
public final class ImmutableErrorResponse
implements ErrorResponse {
    private final int code;
    private final String message;
    @Nullable
    private final JsonNode error;
    @Nullable
    private final ErrorResponse.ErrorDetails errors;
    private transient int hashCode;

    private ImmutableErrorResponse(int code, String message, @Nullable JsonNode error, @Nullable ErrorResponse.ErrorDetails errors) {
        this.code = code;
        this.message = Objects.requireNonNull(message, "message");
        this.error = error;
        this.errors = errors;
    }

    private ImmutableErrorResponse(ImmutableErrorResponse original, int code, String message, @Nullable JsonNode error, @Nullable ErrorResponse.ErrorDetails errors) {
        this.code = code;
        this.message = message;
        this.error = error;
        this.errors = errors;
    }

    @Override
    @JsonProperty(required=true)
    public int code() {
        return this.code;
    }

    @Override
    @JsonProperty(required=true)
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public JsonNode error() {
        return this.error;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ErrorResponse.ErrorDetails errors() {
        return this.errors;
    }

    public final ImmutableErrorResponse withCode(int value) {
        if (this.code == value) {
            return this;
        }
        return new ImmutableErrorResponse(this, value, this.message, this.error, this.errors);
    }

    public final ImmutableErrorResponse withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, newValue, this.error, this.errors);
    }

    public final ImmutableErrorResponse withError(@Nullable JsonNode value) {
        if (this.error == value) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, this.message, value, this.errors);
    }

    public final ImmutableErrorResponse withErrors(@Nullable ErrorResponse.ErrorDetails value) {
        if (this.errors == value) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, this.message, this.error, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorResponse && this.equalsByValue((ImmutableErrorResponse)another);
    }

    private boolean equalsByValue(ImmutableErrorResponse another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.code == another.code && this.message.equals(another.message) && Objects.equals(this.error, another.error) && Objects.equals(this.errors, another.errors);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.code;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.errors);
        return h;
    }

    public String toString() {
        return "ErrorResponse{code=" + this.code + ", message=" + this.message + ", error=" + String.valueOf(this.error) + ", errors=" + String.valueOf(this.errors) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorResponse fromJson(Json json) {
        Builder builder = ImmutableErrorResponse.builder();
        if (json.codeIsSet) {
            builder.code(json._code);
        }
        if (json._message != null) {
            builder.message(json._message);
        }
        if (json._error != null) {
            builder.error(json._error);
        }
        if (json._errors != null) {
            builder.errors(json._errors);
        }
        return builder.build();
    }

    public static ImmutableErrorResponse of(int code, String message, @Nullable JsonNode error, @Nullable ErrorResponse.ErrorDetails errors) {
        return new ImmutableErrorResponse(code, message, error, errors);
    }

    public static ImmutableErrorResponse copyOf(ErrorResponse instance) {
        if (instance instanceof ImmutableErrorResponse) {
            return (ImmutableErrorResponse)instance;
        }
        return ImmutableErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        private int code;
        private String message;
        private JsonNode error;
        private ErrorResponse.ErrorDetails errors;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorResponse instance) {
            ErrorResponse.ErrorDetails errorsValue;
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            this.message(instance.message());
            JsonNode errorValue = instance.error();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((errorsValue = instance.errors()) != null) {
                this.errors(errorsValue);
            }
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder code(int code) {
            this.code = code;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder error(@Nullable JsonNode error) {
            this.error = error;
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder errors(@Nullable ErrorResponse.ErrorDetails errors) {
            this.errors = errors;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.code = 0;
            this.message = null;
            this.error = null;
            this.errors = null;
            return this;
        }

        public ImmutableErrorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorResponse(null, this.code, this.message, this.error, this.errors);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ErrorResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ErrorResponse", generator="Immutables")
    static final class Json
    implements ErrorResponse {
        @JsonIgnore
        int _code;
        @JsonIgnore
        boolean codeIsSet;
        @JsonIgnore
        String _message;
        @JsonIgnore
        JsonNode _error;
        @JsonIgnore
        ErrorResponse.ErrorDetails _errors;

        Json() {
        }

        @JsonProperty(required=true)
        public void setCode(int code) {
            this._code = code;
            this.codeIsSet = true;
        }

        @JsonProperty(required=true)
        public void setMessage(String message) {
            this._message = message;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setError(@Nullable JsonNode error) {
            this._error = error;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setErrors(@Nullable ErrorResponse.ErrorDetails errors) {
            this._errors = errors;
        }

        @Override
        public int code() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode error() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorResponse.ErrorDetails errors() {
            throw new UnsupportedOperationException();
        }
    }
}

