/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.sts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.sts.Credentials;

@Generated(from="Credentials", generator="Immutables")
public final class ImmutableCredentials
implements Credentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    @Nullable
    private final String sessionToken;
    private final Instant expiration;

    private ImmutableCredentials(String accessKeyId, String secretAccessKey, @Nullable String sessionToken, Instant expiration) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expiration = expiration;
    }

    @Override
    @JsonProperty(value="AccessKeyId")
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    @JsonProperty(value="SecretAccessKey")
    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    @Override
    @JsonProperty(value="SessionToken")
    @Nullable
    public String sessionToken() {
        return this.sessionToken;
    }

    @Override
    @JsonProperty(value="Expiration")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant expiration() {
        return this.expiration;
    }

    public final ImmutableCredentials withAccessKeyId(String value) {
        String newValue = Objects.requireNonNull(value, "accessKeyId");
        if (this.accessKeyId.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(newValue, this.secretAccessKey, this.sessionToken, this.expiration);
    }

    public final ImmutableCredentials withSecretAccessKey(String value) {
        String newValue = Objects.requireNonNull(value, "secretAccessKey");
        if (this.secretAccessKey.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(this.accessKeyId, newValue, this.sessionToken, this.expiration);
    }

    public final ImmutableCredentials withSessionToken(@Nullable String value) {
        if (Objects.equals(this.sessionToken, value)) {
            return this;
        }
        return new ImmutableCredentials(this.accessKeyId, this.secretAccessKey, value, this.expiration);
    }

    public final ImmutableCredentials withExpiration(Instant value) {
        if (this.expiration == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "expiration");
        return new ImmutableCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCredentials && this.equalsByValue((ImmutableCredentials)another);
    }

    private boolean equalsByValue(ImmutableCredentials another) {
        return this.accessKeyId.equals(another.accessKeyId) && this.secretAccessKey.equals(another.secretAccessKey) && Objects.equals(this.sessionToken, another.sessionToken) && this.expiration.equals(another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessKeyId.hashCode();
        h += (h << 5) + this.secretAccessKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.sessionToken);
        h += (h << 5) + this.expiration.hashCode();
        return h;
    }

    public String toString() {
        return "Credentials{accessKeyId=" + this.accessKeyId + ", secretAccessKey=" + this.secretAccessKey + ", sessionToken=" + this.sessionToken + ", expiration=" + String.valueOf(this.expiration) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCredentials fromJson(Json json) {
        Builder builder = ImmutableCredentials.builder();
        if (json._accessKeyId != null) {
            builder.accessKeyId(json._accessKeyId);
        }
        if (json._secretAccessKey != null) {
            builder.secretAccessKey(json._secretAccessKey);
        }
        if (json._sessionToken != null) {
            builder.sessionToken(json._sessionToken);
        }
        if (json._expiration != null) {
            builder.expiration(json._expiration);
        }
        return builder.build();
    }

    public static ImmutableCredentials copyOf(Credentials instance) {
        if (instance instanceof ImmutableCredentials) {
            return (ImmutableCredentials)instance;
        }
        return ImmutableCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Credentials", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACCESS_KEY_ID = 1L;
        private static final long INIT_BIT_SECRET_ACCESS_KEY = 2L;
        private static final long INIT_BIT_EXPIRATION = 4L;
        private long initBits = 7L;
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Instant expiration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Credentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessKeyId(instance.accessKeyId());
            this.secretAccessKey(instance.secretAccessKey());
            String sessionTokenValue = instance.sessionToken();
            if (sessionTokenValue != null) {
                this.sessionToken(sessionTokenValue);
            }
            this.expiration(instance.expiration());
            return this;
        }

        @JsonProperty(value="AccessKeyId")
        @CanIgnoreReturnValue
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = Objects.requireNonNull(accessKeyId, "accessKeyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="SecretAccessKey")
        @CanIgnoreReturnValue
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = Objects.requireNonNull(secretAccessKey, "secretAccessKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="SessionToken")
        @CanIgnoreReturnValue
        public final Builder sessionToken(@Nullable String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @JsonProperty(value="Expiration")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
        @JsonSerialize(using=InstantSerializer.class)
        @JsonDeserialize(using=InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder expiration(Instant expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.expiration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessKeyId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secretAccessKey");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiration");
            }
            return "Cannot build Credentials, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Credentials", generator="Immutables")
    static final class Json
    implements Credentials {
        @JsonIgnore
        String _accessKeyId;
        @JsonIgnore
        String _secretAccessKey;
        @JsonIgnore
        String _sessionToken;
        @JsonIgnore
        Instant _expiration;

        Json() {
        }

        @JsonProperty(value="AccessKeyId")
        public void setAccessKeyId(String accessKeyId) {
            this._accessKeyId = accessKeyId;
        }

        @JsonProperty(value="SecretAccessKey")
        public void setSecretAccessKey(String secretAccessKey) {
            this._secretAccessKey = secretAccessKey;
        }

        @JsonProperty(value="SessionToken")
        public void setSessionToken(@Nullable String sessionToken) {
            this._sessionToken = sessionToken;
        }

        @JsonProperty(value="Expiration")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSX", timezone="UTC")
        @JsonSerialize(using=InstantSerializer.class)
        @JsonDeserialize(using=InstantDeserializer.class)
        public void setExpiration(Instant expiration) {
            this._expiration = expiration;
        }

        @Override
        public String accessKeyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String secretAccessKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sessionToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant expiration() {
            throw new UnsupportedOperationException();
        }
    }
}

