/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.fasterxml.jackson.jakarta.rs.xml.JacksonXMLProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.immutables.value.Value;
import org.projectnessie.objectstoragemock.AccessCheckHandler;
import org.projectnessie.objectstoragemock.AdlsGen2Resource;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.GcsResource;
import org.projectnessie.objectstoragemock.ImmutableObjectStorageMock;
import org.projectnessie.objectstoragemock.S3Resource;
import org.projectnessie.objectstoragemock.StsResource;
import org.projectnessie.objectstoragemock.sts.AssumeRoleHandler;
import org.projectnessie.objectstoragemock.sts.ImmutableAssumeRoleResult;
import org.projectnessie.objectstoragemock.sts.ImmutableCredentials;
import org.projectnessie.objectstoragemock.sts.ImmutableRoleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class ObjectStorageMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectStorageMock.class);

    @Value.Default
    public String initAddress() {
        return "127.0.0.1";
    }

    public static ImmutableObjectStorageMock.Builder builder() {
        return ImmutableObjectStorageMock.builder();
    }

    public abstract Map<String, Bucket> buckets();

    @Value.Default
    public AssumeRoleHandler assumeRoleHandler() {
        return (action, version, roleArn, roleSessionName, policy, durationSeconds, externalId, serialNumber) -> ImmutableAssumeRoleResult.builder().credentials(ImmutableCredentials.builder().accessKeyId("access-key-id").secretAccessKey("secret-access-key").expiration(Instant.now().plus(15L, ChronoUnit.MINUTES)).build()).sourceIdentity("source-identity").assumedRoleUser(ImmutableRoleUser.builder().arn("arn").assumedRoleId("assumedRoleId").build()).build();
    }

    @Value.Default
    public AccessCheckHandler accessCheckHandler() {
        return key -> true;
    }

    public MockServer start() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(ObjectStorageMock.this).to(ObjectStorageMock.class);
            }
        });
        config.register(JacksonXMLProvider.class);
        config.register(S3Resource.class);
        config.register(AdlsGen2Resource.class);
        config.register(GcsResource.class);
        config.register(StsResource.class);
        if (LOGGER.isDebugEnabled()) {
            config.register(requestContext -> {
                LOGGER.debug("{} {} {}", new Object[]{requestContext.getMethod(), requestContext.getUriInfo().getPath(), requestContext.getUriInfo().getRequestUri().getQuery()});
                requestContext.getHeaders().forEach((k, v) -> LOGGER.debug("  {}: {}", k, v));
            });
            config.register((requestContext, responseContext) -> {
                LOGGER.debug("{}", (Object)responseContext.getStatusInfo());
                responseContext.getHeaders().forEach((k, v) -> LOGGER.debug("  {}: {}", k, v));
            });
        }
        URI initUri = URI.create(String.format("http://%s:0/", this.initAddress()));
        return new MockServerImpl(initUri, config);
    }

    private static final class MockServerImpl
    implements MockServer {
        private final Server server;
        private final URI baseUri;

        public MockServerImpl(URI initUri, ResourceConfig config) {
            this.server = JettyHttpContainerFactory.createServer((URI)initUri, (ResourceConfig)config, (boolean)true);
            this.customizeUriCompliance();
            this.baseUri = MockServerImpl.baseUri(this.server, initUri);
            LOGGER.info("Object storage mock started started at {}", (Object)this.baseUri);
        }

        private void customizeUriCompliance() {
            for (Connector connector : this.server.getConnectors()) {
                connector.getConnectionFactories().stream().filter(factory -> factory instanceof HttpConnectionFactory).forEach(factory -> {
                    HttpConfiguration httpConfig = ((HttpConnectionFactory)factory).getHttpConfiguration();
                    httpConfig.setUriCompliance(UriCompliance.from(Set.of(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR)));
                });
            }
        }

        private static URI baseUri(Server server, URI initUri) {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof ServerConnector)) continue;
                ServerConnector sc = (ServerConnector)connector;
                int localPort = sc.getLocalPort();
                try {
                    return new URI(initUri.getScheme(), initUri.getUserInfo(), initUri.getHost(), localPort, initUri.getPath(), null, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("Server has no connectors");
        }

        @Override
        public URI getStsEndpointURI() {
            return this.baseUri.resolve("sts/assumeRole");
        }

        @Override
        public URI getS3BaseUri() {
            return this.baseUri;
        }

        @Override
        public URI getGcsBaseUri() {
            return this.baseUri;
        }

        @Override
        public URI getAdlsGen2BaseUri() {
            return this.baseUri.resolve("adlsgen2/");
        }

        @Override
        public void close() throws Exception {
            if (this.server != null) {
                LOGGER.info("Stopping object storage mock server at {}", (Object)this.baseUri);
                this.server.stop();
            }
        }
    }

    public static interface MockServer
    extends AutoCloseable {
        public URI getS3BaseUri();

        public URI getGcsBaseUri();

        public URI getAdlsGen2BaseUri();

        public URI getStsEndpointURI();

        default public Map<String, String> icebergProperties() {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("s3.access-key-id", "accessKey");
            props.put("s3.secret-access-key", "secretKey");
            props.put("s3.endpoint", this.getS3BaseUri().toString());
            props.put("s3.path-style-access", "true");
            props.put("http-client.type", "urlconnection");
            return props;
        }
    }
}

