/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.arc.profile.IfBuildProfile;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.projectnessie.objectstoragemock.AwsChunkedInputStream;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.ObjectStorageMock;
import org.projectnessie.objectstoragemock.Range;
import org.projectnessie.objectstoragemock.s3.BatchDeleteRequest;
import org.projectnessie.objectstoragemock.s3.Bucket;
import org.projectnessie.objectstoragemock.s3.DeletedS3Object;
import org.projectnessie.objectstoragemock.s3.ErrorObj;
import org.projectnessie.objectstoragemock.s3.ErrorResponse;
import org.projectnessie.objectstoragemock.s3.ImmutableBatchDeleteResponse;
import org.projectnessie.objectstoragemock.s3.ImmutableBucket;
import org.projectnessie.objectstoragemock.s3.ImmutableBuckets;
import org.projectnessie.objectstoragemock.s3.ImmutableDeletedS3Object;
import org.projectnessie.objectstoragemock.s3.ImmutableErrorObj;
import org.projectnessie.objectstoragemock.s3.ImmutableListAllMyBucketsResult;
import org.projectnessie.objectstoragemock.s3.ImmutableS3Object;
import org.projectnessie.objectstoragemock.s3.ListAllMyBucketsResult;
import org.projectnessie.objectstoragemock.s3.ListBucketResult;
import org.projectnessie.objectstoragemock.s3.ListBucketResultBase;
import org.projectnessie.objectstoragemock.s3.ListBucketResultV2;
import org.projectnessie.objectstoragemock.s3.Owner;
import org.projectnessie.objectstoragemock.s3.Prefix;
import org.projectnessie.objectstoragemock.s3.S3Object;
import org.projectnessie.objectstoragemock.s3.S3ObjectIdentifier;
import org.projectnessie.objectstoragemock.util.Holder;
import org.projectnessie.objectstoragemock.util.PrefixSpliterator;
import org.projectnessie.objectstoragemock.util.StartAfterSpliterator;

@Path(value="/")
@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
@IfBuildProfile(value="never-include")
public class S3Resource {
    @Inject
    ObjectStorageMock mockServer;
    private static final Owner TEST_OWNER = Owner.of(42L, "nessie-iceberg-s3-mock");

    @Path(value="ready")
    @GET
    @Produces(value={"application/json"})
    public JsonNode ready() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("ready", true);
        return node;
    }

    @GET
    public ListAllMyBucketsResult listBuckets() {
        ImmutableBuckets.Builder buckets = ImmutableBuckets.builder();
        this.mockServer.buckets().forEach((name, bucket) -> buckets.addBuckets((Bucket)ImmutableBucket.builder().name((String)name).creationDate(bucket.creationDate()).build()));
        return ImmutableListAllMyBucketsResult.builder().owner(TEST_OWNER).buckets(buckets.build()).build();
    }

    @PUT
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response createBucket(@PathParam(value="bucketName") String bucketName) {
        return S3Resource.notImplemented();
    }

    @HEAD
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response headBucket(@PathParam(value="bucketName") String bucketName) {
        return this.withBucket(bucketName, b -> Response.ok().build());
    }

    @DELETE
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response deleteBucket(@PathParam(value="bucketName") String bucketName) {
        return S3Resource.notImplemented();
    }

    @GET
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response listObjectsInsideBucket(@PathParam(value="bucketName") String bucketName, @QueryParam(value="prefix") String prefix, @QueryParam(value="delimiter") @DefaultValue(value="/") String delimiter, @QueryParam(value="marker") String marker, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="max-keys") @DefaultValue(value="1000") int maxKeys, @QueryParam(value="list-type") @DefaultValue(value="1") int listType, @QueryParam(value="continuation-token") String continuationToken, @QueryParam(value="start-after") String startAfter, @HeaderParam(value="x-amz-request-id") String requestId) {
        return this.withBucket(bucketName, b -> {
            String offset = continuationToken != null ? continuationToken : startAfter;
            try (Stream<Bucket.ListElement> listStream = b.lister().list(prefix, offset);){
                ListBucketResultBase result;
                ListBucketResultBase.Builder<ListBucketResult.Builder> base;
                ListBucketResult.Builder v1 = null;
                ListBucketResultV2.Builder v2 = null;
                switch (listType) {
                    case 1: {
                        v1 = ListBucketResult.builder();
                        base = v1;
                        break;
                    }
                    case 2: {
                        v2 = ListBucketResultV2.builder();
                        base = v2;
                        break;
                    }
                    default: {
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                        return response;
                    }
                }
                boolean truncated = false;
                String nextMarker = null;
                String nextContinuationToken = null;
                int keyCount = 0;
                HashSet<String> prefixes = new HashSet<String>();
                String lastKey = null;
                Spliterator<Bucket.ListElement> split = listStream.spliterator();
                if (offset != null) {
                    split = new StartAfterSpliterator<Bucket.ListElement>(split, e -> e.key().compareTo(offset) >= 0);
                }
                if (prefix != null && !prefix.isEmpty()) {
                    String effectivePrefix = prefix.endsWith(delimiter) ? prefix : prefix + delimiter;
                    split = new PrefixSpliterator<Bucket.ListElement>(split, e -> e.key().startsWith(effectivePrefix));
                }
                Holder current = new Holder();
                while (split.tryAdvance(current::set)) {
                    if (keyCount == maxKeys) {
                        truncated = true;
                        nextMarker = lastKey;
                        nextContinuationToken = lastKey;
                        break;
                    }
                    String key = ((Bucket.ListElement)current.get()).key();
                    int i = key.lastIndexOf(delimiter);
                    String pre = i > 0 ? key.substring(0, i) : "";
                    MockObject obj = ((Bucket.ListElement)current.get()).object();
                    base.addContents((S3Object)ImmutableS3Object.builder().etag(obj.etag()).key(key).owner(Owner.of(42L, "nobody")).size(Long.toString(obj.contentLength())).lastModified(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(obj.lastModified()), ZoneId.of("UTC")))).storageClass(obj.storageClass()).build());
                    ++keyCount;
                    lastKey = key;
                    if (!prefixes.add(pre)) continue;
                    base.addCommonPrefixes(Prefix.of(pre));
                }
                base.isTruncated(truncated).encodingType(encodingType).maxKeys(maxKeys).name(bucketName);
                switch (listType) {
                    case 1: {
                        result = v1.marker(marker).nextMarker(nextMarker).build();
                        break;
                    }
                    case 2: {
                        result = v2.keyCount(keyCount).continuationToken(continuationToken).nextContinuationToken(nextContinuationToken).startAfter(startAfter).build();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                Response response = Response.ok((Object)result).build();
                return response;
            }
        });
    }

    @POST
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response batchDeleteObjects(@PathParam(value="bucketName") String bucketName, @QueryParam(value="delete") @Nullable String deleteMarker, @RequestBody BatchDeleteRequest body) {
        return this.withBucket(bucketName, b -> {
            ImmutableBatchDeleteResponse.Builder response = ImmutableBatchDeleteResponse.builder();
            for (S3ObjectIdentifier s3ObjectIdentifier : body.objectsToDelete()) {
                if (!this.mockServer.accessCheckHandler().accessAllowed(s3ObjectIdentifier.key())) {
                    return S3Resource.accessDenied();
                }
                if (b.deleter().delete(s3ObjectIdentifier.key())) {
                    response.addDeletedObjects((DeletedS3Object)ImmutableDeletedS3Object.builder().key(s3ObjectIdentifier.key()).versionId(s3ObjectIdentifier.versionId()).build());
                    continue;
                }
                response.addErrors((ErrorObj)ImmutableErrorObj.builder().key(s3ObjectIdentifier.key()).versionId(s3ObjectIdentifier.versionId()).code("NoSuchKey").build());
            }
            return Response.ok((Object)response.build()).build();
        });
    }

    @HEAD
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    public Response headObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName) {
        return this.withBucketObject(bucketName, objectName, obj -> Response.ok().tag(obj.etag()).type(obj.contentType()).header("Content-Length", (Object)obj.contentLength()).lastModified(new Date(obj.lastModified())).build());
    }

    @DELETE
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    public Response deleteObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName) {
        return this.withBucket(bucketName, objectName, b -> {
            b.deleter().delete(objectName);
            return S3Resource.noContent();
        });
    }

    @GET
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    @Produces(value={"*/*"})
    public Response getObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName, @HeaderParam(value="Range") Range range, @HeaderParam(value="If-Match") List<String> match, @HeaderParam(value="If-None-Match") List<String> noneMatch, @HeaderParam(value="If-Modified-Since") Date modifiedSince, @HeaderParam(value="If-Unmodified-Since") Date unmodifiedSince) {
        return this.withBucketObject(bucketName, objectName, obj -> {
            if (unmodifiedSince != null && unmodifiedSince.getTime() > obj.lastModified()) {
                return S3Resource.preconditionFailed();
            }
            if (modifiedSince != null && modifiedSince.getTime() > obj.lastModified()) {
                return S3Resource.notModified(obj.etag());
            }
            if (!match.isEmpty() && !match.contains(obj.etag())) {
                return S3Resource.preconditionFailed();
            }
            if (!noneMatch.isEmpty() && noneMatch.contains(obj.etag())) {
                return S3Resource.notModified(obj.etag());
            }
            StreamingOutput stream = output -> obj.writer().write(range, output);
            Response.ResponseBuilder responseBuilder = Response.ok((Object)stream).tag(obj.etag()).type(obj.contentType()).lastModified(new Date(obj.lastModified()));
            if (range == null) {
                responseBuilder.header("Content-Length", (Object)obj.contentLength());
            }
            return responseBuilder.build();
        });
    }

    @PUT
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    @Consumes(value={"*/*"})
    public Response putObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName, @HeaderParam(value="Content-MD5") String contentMD5, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Content-Encoding") String contentEncoding, InputStream stream) {
        return this.withBucket(bucketName, objectName, bucket -> {
            try {
                InputStream input = stream;
                try {
                    input = this.chunkedInput(contentEncoding, input);
                }
                catch (Exception e) {
                    return Response.status((int)500, (String)e.toString()).build();
                }
                bucket.updater().update(objectName, Bucket.UpdaterMode.UPSERT).append(0L, input).setContentType(contentType).commit();
                return Response.ok().header("Date", (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.now().atZone(ZoneId.of("UTC")))).build();
            }
            catch (UnsupportedOperationException e) {
                return Response.status((int)405, (String)"PUT object not allowed").build();
            }
        });
    }

    private InputStream chunkedInput(String contentEncoding, InputStream input) {
        if (contentEncoding != null) {
            String[] encodings = contentEncoding.split(",");
            boolean identity = false;
            boolean chunked = false;
            String[] stringArray = encodings;
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String encoding;
                switch (encoding = stringArray[i]) {
                    case "identity": {
                        identity = true;
                        continue block8;
                    }
                    case "aws-chunked": {
                        chunked = true;
                        continue block8;
                    }
                }
            }
            if (identity) {
                return input;
            }
            if (chunked) {
                return new AwsChunkedInputStream(input);
            }
        }
        return input;
    }

    private static Response preconditionFailed() {
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("PreconditionFailed", "Precondition Failed")).build();
    }

    private static Response notModified(String etag) {
        return Response.notModified((String)etag).build();
    }

    private static Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private static Response bucketNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("NoSuchBucket", "The specified bucket does not exist.")).build();
    }

    private static Response keyNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("NoSuchKey", "The specified key does not exist.")).build();
    }

    private static Response accessDenied() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("AccessDenied", "Access Denied.")).build();
    }

    private static Response notImplemented() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    private Response withBucket(String bucketName, Function<org.projectnessie.objectstoragemock.Bucket, Response> worker) {
        org.projectnessie.objectstoragemock.Bucket bucket = this.mockServer.buckets().get(bucketName);
        if (bucket == null) {
            return S3Resource.bucketNotFound();
        }
        return worker.apply(bucket);
    }

    private Response withBucket(String bucketName, String objectName, Function<org.projectnessie.objectstoragemock.Bucket, Response> worker) {
        org.projectnessie.objectstoragemock.Bucket bucket = this.mockServer.buckets().get(bucketName);
        if (bucket == null) {
            return S3Resource.bucketNotFound();
        }
        if (!this.mockServer.accessCheckHandler().accessAllowed(objectName)) {
            return S3Resource.accessDenied();
        }
        return worker.apply(bucket);
    }

    private Response withBucketObject(String bucketName, String objectName, Function<MockObject, Response> worker) {
        return this.withBucket(bucketName, objectName, bucket -> {
            MockObject o = bucket.object().retrieve(objectName);
            if (o == null) {
                return S3Resource.keyNotFound();
            }
            return (Response)worker.apply(o);
        });
    }
}

