/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.Owner;
import org.projectnessie.objectstoragemock.s3.S3Object;
import org.projectnessie.objectstoragemock.s3.StorageClass;

@Generated(from="S3Object", generator="Immutables")
public final class ImmutableS3Object
implements S3Object {
    private final String key;
    @Nullable
    private final String lastModified;
    @Nullable
    private final String etag;
    @Nullable
    private final String size;
    @Nullable
    private final StorageClass storageClass;
    @Nullable
    private final Owner owner;

    private ImmutableS3Object(String key, @Nullable String lastModified, @Nullable String etag, @Nullable String size, @Nullable StorageClass storageClass, @Nullable Owner owner) {
        this.key = key;
        this.lastModified = lastModified;
        this.etag = etag;
        this.size = size;
        this.storageClass = storageClass;
        this.owner = owner;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="LastModified")
    @Nullable
    public String lastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="ETag")
    @Nullable
    public String etag() {
        return this.etag;
    }

    @Override
    @JsonProperty(value="Size")
    @Nullable
    public String size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="StorageClass")
    @Nullable
    public StorageClass storageClass() {
        return this.storageClass;
    }

    @Override
    @JsonProperty(value="Owner")
    @Nullable
    public Owner owner() {
        return this.owner;
    }

    public final ImmutableS3Object withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Object(newValue, this.lastModified, this.etag, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withLastModified(@Nullable String value) {
        if (Objects.equals(this.lastModified, value)) {
            return this;
        }
        return new ImmutableS3Object(this.key, value, this.etag, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withEtag(@Nullable String value) {
        if (Objects.equals(this.etag, value)) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, value, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withSize(@Nullable String value) {
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, value, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withStorageClass(@Nullable StorageClass value) {
        if (this.storageClass == value) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, value, this.owner);
    }

    public final ImmutableS3Object withOwner(@Nullable Owner value) {
        if (this.owner == value) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, this.storageClass, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3Object && this.equalsByValue((ImmutableS3Object)another);
    }

    private boolean equalsByValue(ImmutableS3Object another) {
        return this.key.equals(another.key) && Objects.equals(this.lastModified, another.lastModified) && Objects.equals(this.etag, another.etag) && Objects.equals(this.size, another.size) && Objects.equals((Object)this.storageClass, (Object)another.storageClass) && Objects.equals(this.owner, another.owner);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + Objects.hashCode(this.etag);
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + Objects.hashCode((Object)this.storageClass);
        h += (h << 5) + Objects.hashCode(this.owner);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"S3Object").omitNullValues().add("key", (Object)this.key).add("lastModified", (Object)this.lastModified).add("etag", (Object)this.etag).add("size", (Object)this.size).add("storageClass", (Object)this.storageClass).add("owner", (Object)this.owner).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableS3Object fromJson(Json json) {
        Builder builder = ImmutableS3Object.builder();
        if (json._key != null) {
            builder.key(json._key);
        }
        if (json._lastModified != null) {
            builder.lastModified(json._lastModified);
        }
        if (json._etag != null) {
            builder.etag(json._etag);
        }
        if (json._size != null) {
            builder.size(json._size);
        }
        if (json._storageClass != null) {
            builder.storageClass(json._storageClass);
        }
        if (json._owner != null) {
            builder.owner(json._owner);
        }
        return builder.build();
    }

    public static ImmutableS3Object copyOf(S3Object instance) {
        if (instance instanceof ImmutableS3Object) {
            return (ImmutableS3Object)instance;
        }
        return ImmutableS3Object.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3Object", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        private String key;
        private String lastModified;
        private String etag;
        private String size;
        private StorageClass storageClass;
        private Owner owner;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3Object instance) {
            Owner ownerValue;
            StorageClass storageClassValue;
            String sizeValue;
            String etagValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            String lastModifiedValue = instance.lastModified();
            if (lastModifiedValue != null) {
                this.lastModified(lastModifiedValue);
            }
            if ((etagValue = instance.etag()) != null) {
                this.etag(etagValue);
            }
            if ((sizeValue = instance.size()) != null) {
                this.size(sizeValue);
            }
            if ((storageClassValue = instance.storageClass()) != null) {
                this.storageClass(storageClassValue);
            }
            if ((ownerValue = instance.owner()) != null) {
                this.owner(ownerValue);
            }
            return this;
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="LastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(@Nullable String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @JsonProperty(value="ETag")
        @CanIgnoreReturnValue
        public final Builder etag(@Nullable String etag) {
            this.etag = etag;
            return this;
        }

        @JsonProperty(value="Size")
        @CanIgnoreReturnValue
        public final Builder size(@Nullable String size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="StorageClass")
        @CanIgnoreReturnValue
        public final Builder storageClass(@Nullable StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @JsonProperty(value="Owner")
        @CanIgnoreReturnValue
        public final Builder owner(@Nullable Owner owner) {
            this.owner = owner;
            return this;
        }

        public ImmutableS3Object build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, this.storageClass, this.owner);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build S3Object, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="S3Object", generator="Immutables")
    static final class Json
    implements S3Object {
        @JsonIgnore
        String _key;
        @JsonIgnore
        String _lastModified;
        @JsonIgnore
        String _etag;
        @JsonIgnore
        String _size;
        @JsonIgnore
        StorageClass _storageClass;
        @JsonIgnore
        Owner _owner;

        Json() {
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this._key = key;
        }

        @JsonProperty(value="LastModified")
        public void setLastModified(@Nullable String lastModified) {
            this._lastModified = lastModified;
        }

        @JsonProperty(value="ETag")
        public void setEtag(@Nullable String etag) {
            this._etag = etag;
        }

        @JsonProperty(value="Size")
        public void setSize(@Nullable String size) {
            this._size = size;
        }

        @JsonProperty(value="StorageClass")
        public void setStorageClass(@Nullable StorageClass storageClass) {
            this._storageClass = storageClass;
        }

        @JsonProperty(value="Owner")
        public void setOwner(@Nullable Owner owner) {
            this._owner = owner;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String etag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageClass storageClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Owner owner() {
            throw new UnsupportedOperationException();
        }
    }
}

