/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.ObjectStorageMock;
import org.projectnessie.objectstoragemock.Range;
import org.projectnessie.objectstoragemock.gcs.ImmutableErrorResponse;
import org.projectnessie.objectstoragemock.gcs.ImmutableListResponse;
import org.projectnessie.objectstoragemock.gcs.ImmutableStorageObject;
import org.projectnessie.objectstoragemock.gcs.ObjectAlt;
import org.projectnessie.objectstoragemock.gcs.StorageObject;
import org.projectnessie.objectstoragemock.gcs.UploadType;
import org.projectnessie.objectstoragemock.util.Holder;
import org.projectnessie.objectstoragemock.util.PrefixSpliterator;
import org.projectnessie.objectstoragemock.util.StartAfterSpliterator;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GcsResource {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Inject
    ObjectStorageMock mockServer;

    @GET
    @Path(value="/storage/v1/b")
    public Response listBuckets() {
        return GcsResource.notImplemented();
    }

    @PUT
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}")
    public Response getBucket() {
        return GcsResource.notImplemented();
    }

    @POST
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}")
    public Response createBucket() {
        return GcsResource.notImplemented();
    }

    @DELETE
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}")
    public Response deleteBucket() {
        return GcsResource.notImplemented();
    }

    @GET
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}/o")
    public Response listObjects(@PathParam(value="bucketName") String bucketName, @QueryParam(value="delimiter") @DefaultValue(value="/") String delimiter, @QueryParam(value="endOffset") String endOffset, @QueryParam(value="maxResults") @DefaultValue(value="2147483647") int maxResults, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="prefix") String prefix, @QueryParam(value="startOffset") String startOffset) {
        return this.withBucket(bucketName, b -> {
            String offset = pageToken != null ? pageToken : startOffset;
            try (Stream<Bucket.ListElement> listStream = b.lister().list(prefix, offset);){
                String nextPageToken = null;
                int keyCount = 0;
                HashSet<String> prefixes = new HashSet<String>();
                String lastKey = null;
                Spliterator<Bucket.ListElement> split = listStream.spliterator();
                if (offset != null) {
                    split = new StartAfterSpliterator<Bucket.ListElement>(split, e -> e.key().compareTo(offset) >= 0);
                }
                if (prefix != null && !prefix.isEmpty()) {
                    String effectivePrefix = prefix.endsWith(delimiter) ? prefix : prefix + delimiter;
                    split = new PrefixSpliterator<Bucket.ListElement>(split, e -> e.key().startsWith(effectivePrefix));
                }
                ImmutableListResponse.Builder response = ImmutableListResponse.builder();
                Holder current = new Holder();
                while (split.tryAdvance(current::set)) {
                    if (keyCount == maxResults) {
                        nextPageToken = lastKey;
                        break;
                    }
                    String key = ((Bucket.ListElement)current.get()).key();
                    if (endOffset != null && endOffset.compareTo(key) < 0) break;
                    int i = key.lastIndexOf(delimiter);
                    String pre = i > 0 ? key.substring(0, i) : "";
                    MockObject obj = ((Bucket.ListElement)current.get()).object();
                    response.addItems(GcsResource.storageObject(bucketName, key, obj));
                    ++keyCount;
                    lastKey = key;
                    if (!prefixes.add(pre)) continue;
                }
                response.nextPageToken(nextPageToken);
                Response response2 = Response.ok((Object)response.build()).build();
                return response2;
            }
        });
    }

    @DELETE
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}/o/{object:.+}")
    @Consumes(value={"*/*"})
    public Response deleteObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName) {
        return this.withBucket(bucketName, b -> {
            if (!b.deleter().delete(objectName)) {
                return GcsResource.keyNotFound();
            }
            return GcsResource.noContent();
        });
    }

    @GET
    @Path(value="/download/storage/v1/b/{bucketName:[a-z0-9.-]+}/o/{object:.+}")
    @Produces(value={"*/*"})
    public Response downloadObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName, @QueryParam(value="alt") @DefaultValue(value="json") ObjectAlt alt, @HeaderParam(value="Range") Range range, @HeaderParam(value="If-Match") List<String> match, @HeaderParam(value="If-None-Match") List<String> noneMatch, @HeaderParam(value="If-Modified-Since") Date modifiedSince, @HeaderParam(value="If-Unmodified-Since") Date unmodifiedSince) {
        return this.getObject(bucketName, objectName, alt, range, match, noneMatch, modifiedSince, unmodifiedSince);
    }

    @GET
    @Path(value="/storage/v1/b/{bucketName:[a-z0-9.-]+}/o/{object:.+}")
    @Produces(value={"*/*"})
    public Response getObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName, @QueryParam(value="alt") @DefaultValue(value="json") ObjectAlt alt, @HeaderParam(value="Range") Range range, @HeaderParam(value="If-Match") List<String> match, @HeaderParam(value="If-None-Match") List<String> noneMatch, @HeaderParam(value="If-Modified-Since") Date modifiedSince, @HeaderParam(value="If-Unmodified-Since") Date unmodifiedSince) {
        if (range != null) {
            // empty if block
        }
        return this.withBucketObject(bucketName, objectName, obj -> {
            if (unmodifiedSince != null && unmodifiedSince.getTime() > obj.lastModified()) {
                return GcsResource.preconditionFailed();
            }
            if (modifiedSince != null && modifiedSince.getTime() > obj.lastModified()) {
                return GcsResource.notModified(obj.etag());
            }
            if (!match.isEmpty() && !match.contains(obj.etag())) {
                return GcsResource.preconditionFailed();
            }
            if (!noneMatch.isEmpty() && noneMatch.contains(obj.etag())) {
                return GcsResource.notModified(obj.etag());
            }
            switch (alt) {
                case json: {
                    return Response.ok((Object)GcsResource.storageObject(bucketName, objectName, obj), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
                }
                case media: {
                    StreamingOutput stream = output -> obj.writer().write(range, output);
                    return Response.ok((Object)stream).tag(obj.etag()).type(obj.contentType()).header("Content-Length", (Object)obj.contentLength()).lastModified(new Date(obj.lastModified())).build();
                }
            }
            throw new IllegalArgumentException("alt = " + alt);
        });
    }

    @PUT
    @Path(value="/upload/storage/v1/b/{bucketName:[a-z0-9.-]+}/o")
    @Consumes(value={"*/*"})
    public Response uploadStuff(@PathParam(value="bucketName") String bucketName, @QueryParam(value="name") String objectName, @QueryParam(value="uploadType") UploadType uploadType, @HeaderParam(value="Content-Type") String contentType, @Context UriInfo uriInfo, InputStream stream) {
        return this.insertObject(bucketName, objectName, uploadType, contentType, uriInfo, stream);
    }

    @POST
    @Path(value="/upload/storage/v1/b/{bucketName:[a-z0-9.-]+}/o")
    @Consumes(value={"*/*"})
    public Response insertObject(@PathParam(value="bucketName") String bucketName, @QueryParam(value="name") String objectName, @QueryParam(value="uploadType") UploadType uploadType, @HeaderParam(value="Content-Type") String contentType, @Context UriInfo uriInfo, InputStream stream) {
        return this.withBucket(bucketName, bucket -> {
            try {
                Bucket.Updater updater = bucket.updater();
                switch (uploadType) {
                    case media: {
                        MockObject obj = updater.update(objectName, Bucket.UpdaterMode.UPSERT).append(0L, stream).setContentType(contentType).commit();
                        return Response.ok((Object)GcsResource.storageObject(bucketName, objectName, obj), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
                    }
                    case multipart: {
                        return GcsResource.notImplemented();
                    }
                    case resumable: {
                        ObjectNode metadata = (ObjectNode)OBJECT_MAPPER.readValue(stream, ObjectNode.class);
                        JsonNode contentTypeNode = metadata.get("contentType");
                        String ct = contentTypeNode != null ? contentTypeNode.textValue() : "application/octet-stream";
                        MockObject obj = updater.update(objectName, Bucket.UpdaterMode.UPSERT).setContentType(ct).commit();
                        return Response.ok((Object)GcsResource.storageObject(bucketName, objectName, obj), (MediaType)MediaType.APPLICATION_JSON_TYPE).header("Location", (Object)uriInfo.getBaseUri().resolve("upload/storage/v1/b/" + URLEncoder.encode(bucketName, StandardCharsets.UTF_8) + "/o?name=" + URLEncoder.encode(objectName, StandardCharsets.UTF_8) + "&uploadType=" + UploadType.appendStuff.name())).build();
                    }
                    case appendStuff: {
                        MockObject obj = updater.update(objectName, Bucket.UpdaterMode.UPDATE).append(0L, stream).commit();
                        return Response.ok((Object)GcsResource.storageObject(bucketName, objectName, obj), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
                    }
                }
                throw new IllegalArgumentException("Unknown upload type: " + uploadType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedOperationException e) {
                return Response.status((int)405, (String)"POST object not allowed").build();
            }
        });
    }

    private static StorageObject storageObject(String bucketName, String key, MockObject obj) {
        return ImmutableStorageObject.builder().etag(obj.etag()).name(key).id(key).size(obj.contentLength()).bucket(bucketName).contentType(obj.contentType()).storageClass(obj.storageClass().name()).updated(Instant.ofEpochMilli(obj.lastModified())).build();
    }

    private static Response preconditionFailed() {
        return GcsResource.errorResponse(Response.Status.PRECONDITION_FAILED, "Precondition Failed");
    }

    private static Response notModified(String etag) {
        return Response.notModified((String)etag).build();
    }

    private static Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private static Response bucketNotFound() {
        return GcsResource.errorResponse(Response.Status.NOT_FOUND, "The specified bucket does not exist.");
    }

    private static Response keyNotFound() {
        return GcsResource.errorResponse(Response.Status.NOT_FOUND, "The specified key does not exist.");
    }

    private static Response errorResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).type("application/json").entity((Object)ImmutableErrorResponse.builder().code(status.getStatusCode()).message(message).build()).build();
    }

    private static Response notImplemented() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    private Response withBucket(String bucketName, Function<Bucket, Response> worker) {
        Bucket bucket = this.mockServer.buckets().get(bucketName);
        if (bucket == null) {
            return GcsResource.bucketNotFound();
        }
        return worker.apply(bucket);
    }

    private Response withBucketObject(String bucketName, String objectName, Function<MockObject, Response> worker) {
        return this.withBucket(bucketName, bucket -> {
            MockObject o = bucket.object().retrieve(objectName);
            if (o == null) {
                return GcsResource.keyNotFound();
            }
            return (Response)worker.apply(o);
        });
    }
}

