/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.ImmutableMockObject;
import org.projectnessie.objectstoragemock.MockObject;

public class HeapStorageBucket {
    private final TreeMap<String, MockObject> objects = new TreeMap();

    private HeapStorageBucket() {
    }

    public static HeapStorageBucket newHeapStorageBucket() {
        return new HeapStorageBucket();
    }

    public void clear() {
        this.objects.clear();
    }

    public Bucket bucket() {
        return Bucket.builder().object(this::retriever).updater(this::updater).lister(this::lister).deleter(this::deleter).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleter(String oid) {
        TreeMap<String, MockObject> treeMap = this.objects;
        synchronized (treeMap) {
            return this.objects.remove(oid) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<Bucket.ListElement> lister(String prefix, String offset) {
        ArrayList<String> keys;
        TreeMap<String, MockObject> treeMap = this.objects;
        synchronized (treeMap) {
            keys = new ArrayList<String>();
            if (prefix != null) {
                String key2;
                String startAt = offset != null && offset.compareTo(prefix) > 0 ? offset : prefix;
                Iterator iterator = this.objects.tailMap(startAt, true).keySet().iterator();
                while (iterator.hasNext() && (key2 = (String)iterator.next()).startsWith(prefix)) {
                    keys.add(key2);
                }
            } else {
                keys.addAll(this.objects.keySet());
            }
        }
        return keys.stream().map(key -> new Bucket.ListElement(){
            final /* synthetic */ String val$key;
            {
                this.val$key = string;
            }

            @Override
            public String key() {
                return this.val$key;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MockObject object() {
                TreeMap<String, MockObject> treeMap = HeapStorageBucket.this.objects;
                synchronized (treeMap) {
                    return HeapStorageBucket.this.objects.get(this.val$key);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket.ObjectUpdater updater(String key, Bucket.UpdaterMode mode) {
        MockObject expected;
        TreeMap<String, MockObject> treeMap = this.objects;
        synchronized (treeMap) {
            expected = this.objects.get(key);
            switch (mode) {
                case CREATE_NEW: {
                    if (expected == null) break;
                    throw new IllegalStateException("Object '" + key + "' already exists");
                }
                case UPDATE: {
                    if (expected != null) break;
                    throw new IllegalStateException("Object '" + key + "' does not exist");
                }
                case UPSERT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(mode.name());
                }
            }
        }
        return new HeapObjectUpdater(expected, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockObject retriever(String key) {
        TreeMap<String, MockObject> treeMap = this.objects;
        synchronized (treeMap) {
            return this.objects.get(key);
        }
    }

    private class HeapObjectUpdater
    implements Bucket.ObjectUpdater {
        private final MockObject expected;
        private final String key;
        private final ImmutableMockObject.Builder object;

        public HeapObjectUpdater(MockObject expected, String key) {
            this.expected = expected;
            this.key = key;
            this.object = ImmutableMockObject.builder();
            if (expected != null) {
                this.object.from(expected);
            }
        }

        @Override
        public Bucket.ObjectUpdater setContentType(String contentType) {
            this.object.contentType(contentType);
            return this;
        }

        @Override
        public Bucket.ObjectUpdater flush() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MockObject commit() {
            TreeMap<String, MockObject> treeMap = HeapStorageBucket.this.objects;
            synchronized (treeMap) {
                MockObject curr = HeapStorageBucket.this.objects.get(this.key);
                if (curr != this.expected) {
                    throw new ConcurrentModificationException("Object '" + this.key + "' has been modified concurrently.");
                }
                ImmutableMockObject obj = this.object.lastModified(System.currentTimeMillis()).build();
                HeapStorageBucket.this.objects.put(this.key, obj);
                return obj;
            }
        }

        @Override
        public Bucket.ObjectUpdater append(long position, InputStream data) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.object.build().writer().write(null, out);
                data.transferTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] newData = out.toByteArray();
            this.object.contentLength(newData.length).writer((range, output) -> {
                if (range == null) {
                    output.write(newData);
                } else {
                    int offset = (int)range.start();
                    long len = Math.min((long)(newData.length - offset), range.end() - range.start());
                    output.write(newData, offset, (int)len);
                }
            });
            return this;
        }
    }
}

