/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.ListPartsResult;
import org.projectnessie.objectstoragemock.s3.Part;
import org.projectnessie.objectstoragemock.s3.StorageClass;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ListPartsResult", generator="Immutables")
@Immutable
public final class ImmutableListPartsResult
implements ListPartsResult {
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final String partNumberMarker;
    private final String nextPartNumberMarker;
    private final boolean truncated;
    private final StorageClass storageClass;
    private final List<Part> parts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableListPartsResult(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.parts = ImmutableListPartsResult.createUnmodifiableList(true, builder.parts);
        if (builder.partNumberMarker != null) {
            this.initShim.partNumberMarker(builder.partNumberMarker);
        }
        if (builder.nextPartNumberMarker != null) {
            this.initShim.nextPartNumberMarker(builder.nextPartNumberMarker);
        }
        if (builder.truncatedIsSet()) {
            this.initShim.truncated(builder.truncated);
        }
        if (builder.storageClass != null) {
            this.initShim.storageClass(builder.storageClass);
        }
        this.partNumberMarker = this.initShim.partNumberMarker();
        this.nextPartNumberMarker = this.initShim.nextPartNumberMarker();
        this.truncated = this.initShim.truncated();
        this.storageClass = this.initShim.storageClass();
        this.initShim = null;
    }

    private ImmutableListPartsResult(String bucket, String key, String uploadId, String partNumberMarker, String nextPartNumberMarker, boolean truncated, StorageClass storageClass, List<Part> parts) {
        this.bucket = bucket;
        this.key = key;
        this.uploadId = uploadId;
        this.partNumberMarker = partNumberMarker;
        this.nextPartNumberMarker = nextPartNumberMarker;
        this.truncated = truncated;
        this.storageClass = storageClass;
        this.parts = parts;
        this.initShim = null;
    }

    private String partNumberMarkerInitialize() {
        return ListPartsResult.super.partNumberMarker();
    }

    private String nextPartNumberMarkerInitialize() {
        return ListPartsResult.super.nextPartNumberMarker();
    }

    private boolean truncatedInitialize() {
        return ListPartsResult.super.truncated();
    }

    private StorageClass storageClassInitialize() {
        return ListPartsResult.super.storageClass();
    }

    @Override
    @JsonProperty(value="Bucket")
    public String bucket() {
        return this.bucket;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="UploadId")
    public String uploadId() {
        return this.uploadId;
    }

    @Override
    @JsonProperty(value="PartNumberMarker")
    public String partNumberMarker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partNumberMarker() : this.partNumberMarker;
    }

    @Override
    @JsonProperty(value="NextPartNumberMarker")
    public String nextPartNumberMarker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nextPartNumberMarker() : this.nextPartNumberMarker;
    }

    @Override
    @JsonProperty(value="IsTruncated")
    public boolean truncated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.truncated() : this.truncated;
    }

    @Override
    @JsonProperty(value="StorageClass")
    public StorageClass storageClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageClass() : this.storageClass;
    }

    @Override
    @JsonProperty(value="Part")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Part> parts() {
        return this.parts;
    }

    public final ImmutableListPartsResult withBucket(String value) {
        String newValue = Objects.requireNonNull(value, "bucket");
        if (this.bucket.equals(newValue)) {
            return this;
        }
        return new ImmutableListPartsResult(newValue, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, newValue, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withUploadId(String value) {
        String newValue = Objects.requireNonNull(value, "uploadId");
        if (this.uploadId.equals(newValue)) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, this.key, newValue, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withPartNumberMarker(String value) {
        String newValue = Objects.requireNonNull(value, "partNumberMarker");
        if (this.partNumberMarker.equals(newValue)) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, newValue, this.nextPartNumberMarker, this.truncated, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withNextPartNumberMarker(String value) {
        String newValue = Objects.requireNonNull(value, "nextPartNumberMarker");
        if (this.nextPartNumberMarker.equals(newValue)) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, this.partNumberMarker, newValue, this.truncated, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withTruncated(boolean value) {
        if (this.truncated == value) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, value, this.storageClass, this.parts);
    }

    public final ImmutableListPartsResult withStorageClass(StorageClass value) {
        StorageClass newValue = Objects.requireNonNull(value, "storageClass");
        if (this.storageClass == newValue) {
            return this;
        }
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, newValue, this.parts);
    }

    public final ImmutableListPartsResult withParts(Part ... elements) {
        List<Part> newValue = ImmutableListPartsResult.createUnmodifiableList(false, ImmutableListPartsResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, this.storageClass, newValue);
    }

    public final ImmutableListPartsResult withParts(Iterable<? extends Part> elements) {
        if (this.parts == elements) {
            return this;
        }
        List<Part> newValue = ImmutableListPartsResult.createUnmodifiableList(false, ImmutableListPartsResult.createSafeList(elements, true, false));
        return new ImmutableListPartsResult(this.bucket, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.truncated, this.storageClass, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListPartsResult && this.equalTo(0, (ImmutableListPartsResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableListPartsResult another) {
        return this.bucket.equals(another.bucket) && this.key.equals(another.key) && this.uploadId.equals(another.uploadId) && this.partNumberMarker.equals(another.partNumberMarker) && this.nextPartNumberMarker.equals(another.nextPartNumberMarker) && this.truncated == another.truncated && this.storageClass.equals((Object)another.storageClass) && this.parts.equals(another.parts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bucket.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.uploadId.hashCode();
        h += (h << 5) + this.partNumberMarker.hashCode();
        h += (h << 5) + this.nextPartNumberMarker.hashCode();
        h += (h << 5) + Boolean.hashCode(this.truncated);
        h += (h << 5) + this.storageClass.hashCode();
        h += (h << 5) + this.parts.hashCode();
        return h;
    }

    public String toString() {
        return "ListPartsResult{bucket=" + this.bucket + ", key=" + this.key + ", uploadId=" + this.uploadId + ", partNumberMarker=" + this.partNumberMarker + ", nextPartNumberMarker=" + this.nextPartNumberMarker + ", truncated=" + this.truncated + ", storageClass=" + this.storageClass + ", parts=" + this.parts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListPartsResult fromJson(Json json) {
        Builder builder = ImmutableListPartsResult.builder();
        if (json.bucket != null) {
            builder.bucket(json.bucket);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.uploadId != null) {
            builder.uploadId(json.uploadId);
        }
        if (json.partNumberMarker != null) {
            builder.partNumberMarker(json.partNumberMarker);
        }
        if (json.nextPartNumberMarker != null) {
            builder.nextPartNumberMarker(json.nextPartNumberMarker);
        }
        if (json.truncatedIsSet) {
            builder.truncated(json.truncated);
        }
        if (json.storageClass != null) {
            builder.storageClass(json.storageClass);
        }
        if (json.parts != null) {
            builder.addAllParts(json.parts);
        }
        return builder.build();
    }

    public static ImmutableListPartsResult copyOf(ListPartsResult instance) {
        if (instance instanceof ImmutableListPartsResult) {
            return (ImmutableListPartsResult)instance;
        }
        return ImmutableListPartsResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListPartsResult", generator="Immutables")
    private final class InitShim {
        private byte partNumberMarkerBuildStage = 0;
        private String partNumberMarker;
        private byte nextPartNumberMarkerBuildStage = 0;
        private String nextPartNumberMarker;
        private byte truncatedBuildStage = 0;
        private boolean truncated;
        private byte storageClassBuildStage = 0;
        private StorageClass storageClass;

        private InitShim() {
        }

        String partNumberMarker() {
            if (this.partNumberMarkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partNumberMarkerBuildStage == 0) {
                this.partNumberMarkerBuildStage = (byte)-1;
                this.partNumberMarker = Objects.requireNonNull(ImmutableListPartsResult.this.partNumberMarkerInitialize(), "partNumberMarker");
                this.partNumberMarkerBuildStage = 1;
            }
            return this.partNumberMarker;
        }

        void partNumberMarker(String partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            this.partNumberMarkerBuildStage = 1;
        }

        String nextPartNumberMarker() {
            if (this.nextPartNumberMarkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nextPartNumberMarkerBuildStage == 0) {
                this.nextPartNumberMarkerBuildStage = (byte)-1;
                this.nextPartNumberMarker = Objects.requireNonNull(ImmutableListPartsResult.this.nextPartNumberMarkerInitialize(), "nextPartNumberMarker");
                this.nextPartNumberMarkerBuildStage = 1;
            }
            return this.nextPartNumberMarker;
        }

        void nextPartNumberMarker(String nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            this.nextPartNumberMarkerBuildStage = 1;
        }

        boolean truncated() {
            if (this.truncatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.truncatedBuildStage == 0) {
                this.truncatedBuildStage = (byte)-1;
                this.truncated = ImmutableListPartsResult.this.truncatedInitialize();
                this.truncatedBuildStage = 1;
            }
            return this.truncated;
        }

        void truncated(boolean truncated) {
            this.truncated = truncated;
            this.truncatedBuildStage = 1;
        }

        StorageClass storageClass() {
            if (this.storageClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageClassBuildStage == 0) {
                this.storageClassBuildStage = (byte)-1;
                this.storageClass = Objects.requireNonNull(ImmutableListPartsResult.this.storageClassInitialize(), "storageClass");
                this.storageClassBuildStage = 1;
            }
            return this.storageClass;
        }

        void storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            this.storageClassBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.partNumberMarkerBuildStage == -1) {
                attributes.add("partNumberMarker");
            }
            if (this.nextPartNumberMarkerBuildStage == -1) {
                attributes.add("nextPartNumberMarker");
            }
            if (this.truncatedBuildStage == -1) {
                attributes.add("truncated");
            }
            if (this.storageClassBuildStage == -1) {
                attributes.add("storageClass");
            }
            return "Cannot build ListPartsResult, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ListPartsResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BUCKET = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private static final long INIT_BIT_UPLOAD_ID = 4L;
        private static final long OPT_BIT_TRUNCATED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String bucket;
        @Nullable
        private String key;
        @Nullable
        private String uploadId;
        @Nullable
        private String partNumberMarker;
        @Nullable
        private String nextPartNumberMarker;
        private boolean truncated;
        @Nullable
        private StorageClass storageClass;
        private List<Part> parts = new ArrayList<Part>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ListPartsResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.bucket(instance.bucket());
            this.key(instance.key());
            this.uploadId(instance.uploadId());
            this.partNumberMarker(instance.partNumberMarker());
            this.nextPartNumberMarker(instance.nextPartNumberMarker());
            this.truncated(instance.truncated());
            this.storageClass(instance.storageClass());
            this.addAllParts(instance.parts());
            return this;
        }

        @JsonProperty(value="Bucket")
        @CanIgnoreReturnValue
        public final Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket, "bucket");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="UploadId")
        @CanIgnoreReturnValue
        public final Builder uploadId(String uploadId) {
            this.uploadId = Objects.requireNonNull(uploadId, "uploadId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="PartNumberMarker")
        @CanIgnoreReturnValue
        public final Builder partNumberMarker(String partNumberMarker) {
            this.partNumberMarker = Objects.requireNonNull(partNumberMarker, "partNumberMarker");
            return this;
        }

        @JsonProperty(value="NextPartNumberMarker")
        @CanIgnoreReturnValue
        public final Builder nextPartNumberMarker(String nextPartNumberMarker) {
            this.nextPartNumberMarker = Objects.requireNonNull(nextPartNumberMarker, "nextPartNumberMarker");
            return this;
        }

        @JsonProperty(value="IsTruncated")
        @CanIgnoreReturnValue
        public final Builder truncated(boolean truncated) {
            this.truncated = truncated;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="StorageClass")
        @CanIgnoreReturnValue
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = Objects.requireNonNull(storageClass, "storageClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParts(Part element) {
            this.parts.add(Objects.requireNonNull(element, "parts element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParts(Part ... elements) {
            for (Part element : elements) {
                this.parts.add(Objects.requireNonNull(element, "parts element"));
            }
            return this;
        }

        @JsonProperty(value="Part")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder parts(Iterable<? extends Part> elements) {
            this.parts.clear();
            return this.addAllParts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParts(Iterable<? extends Part> elements) {
            for (Part part : elements) {
                this.parts.add(Objects.requireNonNull(part, "parts element"));
            }
            return this;
        }

        public ImmutableListPartsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableListPartsResult(this);
        }

        private boolean truncatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bucket");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uploadId");
            }
            return "Cannot build ListPartsResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListPartsResult", generator="Immutables")
    static final class Json
    implements ListPartsResult {
        @Nullable
        String bucket;
        @Nullable
        String key;
        @Nullable
        String uploadId;
        @Nullable
        String partNumberMarker;
        @Nullable
        String nextPartNumberMarker;
        boolean truncated;
        boolean truncatedIsSet;
        @Nullable
        StorageClass storageClass;
        @Nullable
        List<Part> parts = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="Bucket")
        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="UploadId")
        public void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @JsonProperty(value="PartNumberMarker")
        public void setPartNumberMarker(String partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        @JsonProperty(value="NextPartNumberMarker")
        public void setNextPartNumberMarker(String nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
        }

        @JsonProperty(value="IsTruncated")
        public void setTruncated(boolean truncated) {
            this.truncated = truncated;
            this.truncatedIsSet = true;
        }

        @JsonProperty(value="StorageClass")
        public void setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
        }

        @JsonProperty(value="Part")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setParts(List<Part> parts) {
            this.parts = parts;
        }

        @Override
        public String bucket() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String uploadId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String partNumberMarker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextPartNumberMarker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean truncated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageClass storageClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Part> parts() {
            throw new UnsupportedOperationException();
        }
    }
}

