/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.BatchDeleteRequest;
import org.projectnessie.objectstoragemock.s3.S3ObjectIdentifier;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BatchDeleteRequest", generator="Immutables")
@Immutable
public final class ImmutableBatchDeleteRequest
implements BatchDeleteRequest {
    private final boolean quiet;
    private final List<S3ObjectIdentifier> objectsToDelete;

    private ImmutableBatchDeleteRequest(Builder builder) {
        this.objectsToDelete = ImmutableBatchDeleteRequest.createUnmodifiableList(true, builder.objectsToDelete);
        this.quiet = builder.quietIsSet() ? builder.quiet : BatchDeleteRequest.super.quiet();
    }

    private ImmutableBatchDeleteRequest(boolean quiet, List<S3ObjectIdentifier> objectsToDelete) {
        this.quiet = quiet;
        this.objectsToDelete = objectsToDelete;
    }

    @Override
    @JsonProperty(value="Quiet")
    public boolean quiet() {
        return this.quiet;
    }

    @Override
    @JsonProperty(value="Object")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<S3ObjectIdentifier> objectsToDelete() {
        return this.objectsToDelete;
    }

    public final ImmutableBatchDeleteRequest withQuiet(boolean value) {
        if (this.quiet == value) {
            return this;
        }
        return new ImmutableBatchDeleteRequest(value, this.objectsToDelete);
    }

    public final ImmutableBatchDeleteRequest withObjectsToDelete(S3ObjectIdentifier ... elements) {
        List<S3ObjectIdentifier> newValue = ImmutableBatchDeleteRequest.createUnmodifiableList(false, ImmutableBatchDeleteRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBatchDeleteRequest(this.quiet, newValue);
    }

    public final ImmutableBatchDeleteRequest withObjectsToDelete(Iterable<? extends S3ObjectIdentifier> elements) {
        if (this.objectsToDelete == elements) {
            return this;
        }
        List<S3ObjectIdentifier> newValue = ImmutableBatchDeleteRequest.createUnmodifiableList(false, ImmutableBatchDeleteRequest.createSafeList(elements, true, false));
        return new ImmutableBatchDeleteRequest(this.quiet, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchDeleteRequest && this.equalTo(0, (ImmutableBatchDeleteRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableBatchDeleteRequest another) {
        return this.quiet == another.quiet && this.objectsToDelete.equals(another.objectsToDelete);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.quiet);
        h += (h << 5) + this.objectsToDelete.hashCode();
        return h;
    }

    public String toString() {
        return "BatchDeleteRequest{quiet=" + this.quiet + ", objectsToDelete=" + this.objectsToDelete + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBatchDeleteRequest fromJson(Json json) {
        Builder builder = ImmutableBatchDeleteRequest.builder();
        if (json.quietIsSet) {
            builder.quiet(json.quiet);
        }
        if (json.objectsToDelete != null) {
            builder.addAllObjectsToDelete(json.objectsToDelete);
        }
        return builder.build();
    }

    public static ImmutableBatchDeleteRequest copyOf(BatchDeleteRequest instance) {
        if (instance instanceof ImmutableBatchDeleteRequest) {
            return (ImmutableBatchDeleteRequest)instance;
        }
        return ImmutableBatchDeleteRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BatchDeleteRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_QUIET = 1L;
        private long optBits;
        private boolean quiet;
        private List<S3ObjectIdentifier> objectsToDelete = new ArrayList<S3ObjectIdentifier>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BatchDeleteRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.quiet(instance.quiet());
            this.addAllObjectsToDelete(instance.objectsToDelete());
            return this;
        }

        @JsonProperty(value="Quiet")
        @CanIgnoreReturnValue
        public final Builder quiet(boolean quiet) {
            this.quiet = quiet;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectsToDelete(S3ObjectIdentifier element) {
            this.objectsToDelete.add(Objects.requireNonNull(element, "objectsToDelete element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectsToDelete(S3ObjectIdentifier ... elements) {
            for (S3ObjectIdentifier element : elements) {
                this.objectsToDelete.add(Objects.requireNonNull(element, "objectsToDelete element"));
            }
            return this;
        }

        @JsonProperty(value="Object")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder objectsToDelete(Iterable<? extends S3ObjectIdentifier> elements) {
            this.objectsToDelete.clear();
            return this.addAllObjectsToDelete(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectsToDelete(Iterable<? extends S3ObjectIdentifier> elements) {
            for (S3ObjectIdentifier s3ObjectIdentifier : elements) {
                this.objectsToDelete.add(Objects.requireNonNull(s3ObjectIdentifier, "objectsToDelete element"));
            }
            return this;
        }

        public ImmutableBatchDeleteRequest build() {
            return new ImmutableBatchDeleteRequest(this);
        }

        private boolean quietIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BatchDeleteRequest", generator="Immutables")
    static final class Json
    implements BatchDeleteRequest {
        boolean quiet;
        boolean quietIsSet;
        @Nullable
        List<S3ObjectIdentifier> objectsToDelete = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="Quiet")
        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
            this.quietIsSet = true;
        }

        @JsonProperty(value="Object")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setObjectsToDelete(List<S3ObjectIdentifier> objectsToDelete) {
            this.objectsToDelete = objectsToDelete;
        }

        @Override
        public boolean quiet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<S3ObjectIdentifier> objectsToDelete() {
            throw new UnsupportedOperationException();
        }
    }
}

