/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;
import org.projectnessie.objectstoragemock.ImmutableRange;

@JsonSerialize(as=ImmutableRange.class)
@JsonDeserialize(as=ImmutableRange.class)
@Value.Immutable
public interface Range {
    public static final String REQUESTED_RANGE_REGEXP = "^bytes[= ]((\\d*)-(\\d*))((,\\d*-\\d*)*)(/(\\d*))?";
    public static final Pattern REQUESTED_RANGE_PATTERN = Pattern.compile("^bytes[= ]((\\d*)-(\\d*))((,\\d*-\\d*)*)(/(\\d*))?");

    public long start();

    public long end();

    public OptionalLong total();

    public static Range fromString(String rangeString) {
        Objects.requireNonNull(rangeString);
        rangeString = rangeString.trim();
        Matcher matcher = REQUESTED_RANGE_PATTERN.matcher(rangeString);
        if (matcher.matches()) {
            String rangeStart = matcher.group(2);
            String rangeEnd = matcher.group(3);
            String total = matcher.group(7);
            if (matcher.groupCount() == 5 && !"".equals(matcher.group(4))) {
                throw new IllegalArgumentException("Unsupported range specification. Only single range specifications allowed");
            }
            ImmutableRange.Builder range = ImmutableRange.builder().start(rangeStart == null ? 0L : Long.parseLong(rangeStart)).end(rangeEnd.isEmpty() ? Long.MAX_VALUE : Long.parseLong(rangeEnd));
            if (total != null) {
                range.total(Long.parseLong(total));
            }
            return range.build();
        }
        throw new IllegalArgumentException("Range header is malformed. Only bytes supported as range type.");
    }

    @Value.Check
    default public void check() {
        if (this.start() < 0L) {
            throw new IllegalArgumentException("Unsupported range specification. A start byte must be supplied");
        }
        if (this.end() != -1L && this.end() < this.start()) {
            throw new IllegalArgumentException("Range header is malformed. End byte is smaller than start byte.");
        }
    }
}

