/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.sts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.sts.RoleUser;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RoleUser", generator="Immutables")
@Immutable
public final class ImmutableRoleUser
implements RoleUser {
    private final String arn;
    private final String assumedRoleId;

    private ImmutableRoleUser(String arn, String assumedRoleId) {
        this.arn = arn;
        this.assumedRoleId = assumedRoleId;
    }

    @Override
    @JsonProperty(value="Arn")
    public String arn() {
        return this.arn;
    }

    @Override
    @JsonProperty(value="AssumedRoleId")
    public String assumedRoleId() {
        return this.assumedRoleId;
    }

    public final ImmutableRoleUser withArn(String value) {
        String newValue = Objects.requireNonNull(value, "arn");
        if (this.arn.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleUser(newValue, this.assumedRoleId);
    }

    public final ImmutableRoleUser withAssumedRoleId(String value) {
        String newValue = Objects.requireNonNull(value, "assumedRoleId");
        if (this.assumedRoleId.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleUser(this.arn, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleUser && this.equalTo(0, (ImmutableRoleUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleUser another) {
        return this.arn.equals(another.arn) && this.assumedRoleId.equals(another.assumedRoleId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.arn.hashCode();
        h += (h << 5) + this.assumedRoleId.hashCode();
        return h;
    }

    public String toString() {
        return "RoleUser{arn=" + this.arn + ", assumedRoleId=" + this.assumedRoleId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleUser fromJson(Json json) {
        Builder builder = ImmutableRoleUser.builder();
        if (json.arn != null) {
            builder.arn(json.arn);
        }
        if (json.assumedRoleId != null) {
            builder.assumedRoleId(json.assumedRoleId);
        }
        return builder.build();
    }

    public static ImmutableRoleUser copyOf(RoleUser instance) {
        if (instance instanceof ImmutableRoleUser) {
            return (ImmutableRoleUser)instance;
        }
        return ImmutableRoleUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleUser", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARN = 1L;
        private static final long INIT_BIT_ASSUMED_ROLE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String arn;
        @Nullable
        private String assumedRoleId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RoleUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.arn(instance.arn());
            this.assumedRoleId(instance.assumedRoleId());
            return this;
        }

        @JsonProperty(value="Arn")
        @CanIgnoreReturnValue
        public final Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn, "arn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="AssumedRoleId")
        @CanIgnoreReturnValue
        public final Builder assumedRoleId(String assumedRoleId) {
            this.assumedRoleId = Objects.requireNonNull(assumedRoleId, "assumedRoleId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRoleUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleUser(this.arn, this.assumedRoleId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("arn");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("assumedRoleId");
            }
            return "Cannot build RoleUser, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RoleUser", generator="Immutables")
    static final class Json
    implements RoleUser {
        @Nullable
        String arn;
        @Nullable
        String assumedRoleId;

        Json() {
        }

        @JsonProperty(value="Arn")
        public void setArn(String arn) {
            this.arn = arn;
        }

        @JsonProperty(value="AssumedRoleId")
        public void setAssumedRoleId(String assumedRoleId) {
            this.assumedRoleId = assumedRoleId;
        }

        @Override
        public String arn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String assumedRoleId() {
            throw new UnsupportedOperationException();
        }
    }
}

