/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class AwsChunkedInputStream
extends InputStream {
    private final InputStream input;
    private AwsChunkedState state = AwsChunkedState.EXPECT_METADATA;
    private int chunkLen;

    AwsChunkedInputStream(InputStream input) {
        this.input = input;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        block6: while (true) {
            switch (this.state) {
                case EOF: {
                    return -1;
                }
                case EXPECT_METADATA: {
                    String header = this.readLine();
                    if (header == null) {
                        this.state = AwsChunkedState.EOF;
                        continue block6;
                    }
                    String[] parts = header.split(";");
                    this.chunkLen = Integer.parseInt(parts[0], 16);
                    if (this.chunkLen == 0) {
                        this.state = AwsChunkedState.EXPECT_SEPARATOR;
                        continue block6;
                    }
                    this.state = AwsChunkedState.DATA;
                    continue block6;
                }
                case DATA: {
                    if (this.chunkLen == 0) {
                        this.state = AwsChunkedState.EXPECT_SEPARATOR;
                        continue block6;
                    }
                    if ((len = Math.min(this.chunkLen, len)) == 0) {
                        return 0;
                    }
                    int rd = this.input.read(b, off, len);
                    if (rd < 0) {
                        this.state = AwsChunkedState.EOF;
                        throw new EOFException("Unexpected end of chunk input, not enough data");
                    }
                    this.chunkLen -= rd;
                    return rd;
                }
                case EXPECT_SEPARATOR: {
                    String sep = this.readLine();
                    if (sep == null) {
                        this.state = AwsChunkedState.EOF;
                        throw new EOFException("Expecting empty separator line, but got EOF");
                    }
                    Preconditions.checkArgument((boolean)sep.isEmpty(), (String)"Expecting empty separator line, but got '%s'", (Object)sep);
                    this.state = AwsChunkedState.EXPECT_METADATA;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.read(buf, 0, 1);
        if (r <= 0) {
            return r;
        }
        return buf[0] & 0xFF;
    }

    private String readLine() throws IOException {
        StringBuilder line = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.input.read()) == -1) {
                if (line.length() == 0) {
                    return null;
                }
                throw new EOFException("Unexpected end of metadata line");
            }
            if (c == 13) {
                c = this.input.read();
                if (c == -1) {
                    throw new EOFException("Unexpected end of metadata line");
                }
                Preconditions.checkArgument((c == 10 ? 1 : 0) != 0, (Object)"Illegal CR-LF sequence");
                return line.toString();
            }
            line.append((char)c);
            Preconditions.checkArgument((line.length() < 8192 ? 1 : 0) != 0, (Object)"metadata line too long");
        }
    }

    static enum AwsChunkedState {
        EXPECT_METADATA,
        DATA,
        EXPECT_SEPARATOR,
        EOF;

    }
}

