/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.s3.StorageClass;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockObject", generator="Immutables")
@Immutable
public final class ImmutableMockObject
implements MockObject {
    private final String etag;
    private final String contentType;
    private final long contentLength;
    private final long lastModified;
    private final StorageClass storageClass;
    private final MockObject.Writer writer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMockObject(Builder builder) {
        if (builder.etag != null) {
            this.initShim.etag(builder.etag);
        }
        if (builder.contentType != null) {
            this.initShim.contentType(builder.contentType);
        }
        if (builder.contentLengthIsSet()) {
            this.initShim.contentLength(builder.contentLength);
        }
        if (builder.lastModifiedIsSet()) {
            this.initShim.lastModified(builder.lastModified);
        }
        if (builder.storageClass != null) {
            this.initShim.storageClass(builder.storageClass);
        }
        if (builder.writer != null) {
            this.initShim.writer(builder.writer);
        }
        this.etag = this.initShim.etag();
        this.contentType = this.initShim.contentType();
        this.contentLength = this.initShim.contentLength();
        this.lastModified = this.initShim.lastModified();
        this.storageClass = this.initShim.storageClass();
        this.writer = this.initShim.writer();
        this.initShim = null;
    }

    private ImmutableMockObject(String etag, String contentType, long contentLength, long lastModified, StorageClass storageClass, MockObject.Writer writer) {
        this.etag = etag;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.storageClass = storageClass;
        this.writer = writer;
        this.initShim = null;
    }

    private String etagInitialize() {
        return MockObject.super.etag();
    }

    private String contentTypeInitialize() {
        return MockObject.super.contentType();
    }

    private long contentLengthInitialize() {
        return MockObject.super.contentLength();
    }

    private long lastModifiedInitialize() {
        return MockObject.super.lastModified();
    }

    private StorageClass storageClassInitialize() {
        return MockObject.super.storageClass();
    }

    private MockObject.Writer writerInitialize() {
        return MockObject.super.writer();
    }

    @Override
    public String etag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.etag() : this.etag;
    }

    @Override
    public String contentType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contentType() : this.contentType;
    }

    @Override
    public long contentLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contentLength() : this.contentLength;
    }

    @Override
    public long lastModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastModified() : this.lastModified;
    }

    @Override
    public StorageClass storageClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageClass() : this.storageClass;
    }

    @Override
    public MockObject.Writer writer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writer() : this.writer;
    }

    public final ImmutableMockObject withEtag(String value) {
        String newValue = Objects.requireNonNull(value, "etag");
        if (this.etag.equals(newValue)) {
            return this;
        }
        return new ImmutableMockObject(newValue, this.contentType, this.contentLength, this.lastModified, this.storageClass, this.writer);
    }

    public final ImmutableMockObject withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (this.contentType.equals(newValue)) {
            return this;
        }
        return new ImmutableMockObject(this.etag, newValue, this.contentLength, this.lastModified, this.storageClass, this.writer);
    }

    public final ImmutableMockObject withContentLength(long value) {
        if (this.contentLength == value) {
            return this;
        }
        return new ImmutableMockObject(this.etag, this.contentType, value, this.lastModified, this.storageClass, this.writer);
    }

    public final ImmutableMockObject withLastModified(long value) {
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableMockObject(this.etag, this.contentType, this.contentLength, value, this.storageClass, this.writer);
    }

    public final ImmutableMockObject withStorageClass(StorageClass value) {
        StorageClass newValue = Objects.requireNonNull(value, "storageClass");
        if (this.storageClass == newValue) {
            return this;
        }
        return new ImmutableMockObject(this.etag, this.contentType, this.contentLength, this.lastModified, newValue, this.writer);
    }

    public final ImmutableMockObject withWriter(MockObject.Writer value) {
        if (this.writer == value) {
            return this;
        }
        MockObject.Writer newValue = Objects.requireNonNull(value, "writer");
        return new ImmutableMockObject(this.etag, this.contentType, this.contentLength, this.lastModified, this.storageClass, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockObject && this.equalTo(0, (ImmutableMockObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockObject another) {
        return this.etag.equals(another.etag) && this.contentType.equals(another.contentType) && this.contentLength == another.contentLength && this.lastModified == another.lastModified && this.storageClass.equals((Object)another.storageClass) && this.writer.equals(another.writer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.etag.hashCode();
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.contentLength);
        h += (h << 5) + Longs.hashCode((long)this.lastModified);
        h += (h << 5) + this.storageClass.hashCode();
        h += (h << 5) + this.writer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockObject").omitNullValues().add("etag", (Object)this.etag).add("contentType", (Object)this.contentType).add("contentLength", this.contentLength).add("lastModified", this.lastModified).add("storageClass", (Object)this.storageClass).add("writer", (Object)this.writer).toString();
    }

    public static ImmutableMockObject copyOf(MockObject instance) {
        if (instance instanceof ImmutableMockObject) {
            return (ImmutableMockObject)instance;
        }
        return ImmutableMockObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockObject", generator="Immutables")
    private final class InitShim {
        private byte etagBuildStage = 0;
        private String etag;
        private byte contentTypeBuildStage = 0;
        private String contentType;
        private byte contentLengthBuildStage = 0;
        private long contentLength;
        private byte lastModifiedBuildStage = 0;
        private long lastModified;
        private byte storageClassBuildStage = 0;
        private StorageClass storageClass;
        private byte writerBuildStage = 0;
        private MockObject.Writer writer;

        private InitShim() {
        }

        String etag() {
            if (this.etagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.etagBuildStage == 0) {
                this.etagBuildStage = (byte)-1;
                this.etag = Objects.requireNonNull(ImmutableMockObject.this.etagInitialize(), "etag");
                this.etagBuildStage = 1;
            }
            return this.etag;
        }

        void etag(String etag) {
            this.etag = etag;
            this.etagBuildStage = 1;
        }

        String contentType() {
            if (this.contentTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contentTypeBuildStage == 0) {
                this.contentTypeBuildStage = (byte)-1;
                this.contentType = Objects.requireNonNull(ImmutableMockObject.this.contentTypeInitialize(), "contentType");
                this.contentTypeBuildStage = 1;
            }
            return this.contentType;
        }

        void contentType(String contentType) {
            this.contentType = contentType;
            this.contentTypeBuildStage = 1;
        }

        long contentLength() {
            if (this.contentLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contentLengthBuildStage == 0) {
                this.contentLengthBuildStage = (byte)-1;
                this.contentLength = ImmutableMockObject.this.contentLengthInitialize();
                this.contentLengthBuildStage = 1;
            }
            return this.contentLength;
        }

        void contentLength(long contentLength) {
            this.contentLength = contentLength;
            this.contentLengthBuildStage = 1;
        }

        long lastModified() {
            if (this.lastModifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastModifiedBuildStage == 0) {
                this.lastModifiedBuildStage = (byte)-1;
                this.lastModified = ImmutableMockObject.this.lastModifiedInitialize();
                this.lastModifiedBuildStage = 1;
            }
            return this.lastModified;
        }

        void lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.lastModifiedBuildStage = 1;
        }

        StorageClass storageClass() {
            if (this.storageClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageClassBuildStage == 0) {
                this.storageClassBuildStage = (byte)-1;
                this.storageClass = Objects.requireNonNull(ImmutableMockObject.this.storageClassInitialize(), "storageClass");
                this.storageClassBuildStage = 1;
            }
            return this.storageClass;
        }

        void storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            this.storageClassBuildStage = 1;
        }

        MockObject.Writer writer() {
            if (this.writerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writerBuildStage == 0) {
                this.writerBuildStage = (byte)-1;
                this.writer = Objects.requireNonNull(ImmutableMockObject.this.writerInitialize(), "writer");
                this.writerBuildStage = 1;
            }
            return this.writer;
        }

        void writer(MockObject.Writer writer) {
            this.writer = writer;
            this.writerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.etagBuildStage == -1) {
                attributes.add("etag");
            }
            if (this.contentTypeBuildStage == -1) {
                attributes.add("contentType");
            }
            if (this.contentLengthBuildStage == -1) {
                attributes.add("contentLength");
            }
            if (this.lastModifiedBuildStage == -1) {
                attributes.add("lastModified");
            }
            if (this.storageClassBuildStage == -1) {
                attributes.add("storageClass");
            }
            if (this.writerBuildStage == -1) {
                attributes.add("writer");
            }
            return "Cannot build MockObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MockObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_CONTENT_LENGTH = 1L;
        private static final long OPT_BIT_LAST_MODIFIED = 2L;
        private long optBits;
        @Nullable
        private String etag;
        @Nullable
        private String contentType;
        private long contentLength;
        private long lastModified;
        @Nullable
        private StorageClass storageClass;
        @Nullable
        private MockObject.Writer writer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.etag(instance.etag());
            this.contentType(instance.contentType());
            this.contentLength(instance.contentLength());
            this.lastModified(instance.lastModified());
            this.storageClass(instance.storageClass());
            this.writer(instance.writer());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag, "etag");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentLength(long contentLength) {
            this.contentLength = contentLength;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = Objects.requireNonNull(storageClass, "storageClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder writer(MockObject.Writer writer) {
            this.writer = Objects.requireNonNull(writer, "writer");
            return this;
        }

        public ImmutableMockObject build() {
            return new ImmutableMockObject(this);
        }

        private boolean contentLengthIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean lastModifiedIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

