/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.adlsgen2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.adlsgen2.Path;
import org.projectnessie.objectstoragemock.adlsgen2.PathList;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PathList", generator="Immutables")
@Immutable
public final class ImmutablePathList
implements PathList {
    private final List<Path> paths;
    private transient int hashCode;

    private ImmutablePathList(Iterable<? extends Path> paths) {
        this.paths = ImmutablePathList.createUnmodifiableList(false, ImmutablePathList.createSafeList(paths, true, false));
    }

    private ImmutablePathList(ImmutablePathList original, List<Path> paths) {
        this.paths = paths;
    }

    @Override
    @JsonProperty
    public List<Path> paths() {
        return this.paths;
    }

    public final ImmutablePathList withPaths(Path ... elements) {
        List<Path> newValue = ImmutablePathList.createUnmodifiableList(false, ImmutablePathList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePathList(this, newValue);
    }

    public final ImmutablePathList withPaths(Iterable<? extends Path> elements) {
        if (this.paths == elements) {
            return this;
        }
        List<Path> newValue = ImmutablePathList.createUnmodifiableList(false, ImmutablePathList.createSafeList(elements, true, false));
        return new ImmutablePathList(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathList && this.equalTo(0, (ImmutablePathList)another);
    }

    private boolean equalTo(int synthetic, ImmutablePathList another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.paths.equals(another.paths);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.paths.hashCode();
        return h;
    }

    public String toString() {
        return "PathList{paths=" + this.paths + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePathList fromJson(Json json) {
        Builder builder = ImmutablePathList.builder();
        if (json.paths != null) {
            builder.addAllPaths(json.paths);
        }
        return builder.build();
    }

    public static ImmutablePathList of(List<Path> paths) {
        return ImmutablePathList.of(paths);
    }

    public static ImmutablePathList of(Iterable<? extends Path> paths) {
        return new ImmutablePathList(paths);
    }

    public static ImmutablePathList copyOf(PathList instance) {
        if (instance instanceof ImmutablePathList) {
            return (ImmutablePathList)instance;
        }
        return ImmutablePathList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PathList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Path> paths = new ArrayList<Path>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PathList instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPaths(instance.paths());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(Path element) {
            this.paths.add(Objects.requireNonNull(element, "paths element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPaths(Path ... elements) {
            for (Path element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder paths(Iterable<? extends Path> elements) {
            this.paths.clear();
            return this.addAllPaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPaths(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.paths.add(Objects.requireNonNull(path, "paths element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.paths.clear();
            return this;
        }

        public ImmutablePathList build() {
            return new ImmutablePathList(null, ImmutablePathList.createUnmodifiableList(true, this.paths));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PathList", generator="Immutables")
    static final class Json
    implements PathList {
        @Nullable
        List<Path> paths = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setPaths(List<Path> paths) {
            this.paths = paths;
        }

        @Override
        public List<Path> paths() {
            throw new UnsupportedOperationException();
        }
    }
}

