/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.projectnessie.objectstoragemock.Bucket;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.ObjectRetriever;

public final class InterceptingBucket
extends Bucket {
    private final Bucket bucket;
    private volatile Function<String, Optional<MockObject>> retriever;
    private volatile Function<String, Optional<Boolean>> deleter;
    private volatile BiFunction<String, Bucket.UpdaterMode, Optional<Bucket.ObjectUpdater>> updater;
    private volatile BiFunction<String, String, Optional<Stream<Bucket.ListElement>>> lister;

    public InterceptingBucket(Bucket bucket) {
        this.bucket = bucket;
        this.reset();
    }

    public void reset() {
        this.retriever = key -> Optional.empty();
        this.deleter = key -> Optional.empty();
        this.updater = (key, mode) -> Optional.empty();
        this.lister = (prefix, offset) -> Optional.empty();
    }

    public void setRetriever(Function<String, Optional<MockObject>> retriever) {
        this.retriever = retriever;
    }

    public void setDeleter(Function<String, Optional<Boolean>> deleter) {
        this.deleter = deleter;
    }

    public void setUpdater(BiFunction<String, Bucket.UpdaterMode, Optional<Bucket.ObjectUpdater>> updater) {
        this.updater = updater;
    }

    public void setLister(BiFunction<String, String, Optional<Stream<Bucket.ListElement>>> lister) {
        this.lister = lister;
    }

    @Override
    public String creationDate() {
        return this.bucket.creationDate();
    }

    @Override
    public ObjectRetriever object() {
        return key -> this.retriever.apply(key).orElseGet(() -> this.bucket.object().retrieve(key));
    }

    @Override
    public Bucket.Deleter deleter() {
        return key -> this.deleter.apply(key).orElseGet(() -> this.bucket.deleter().delete(key));
    }

    @Override
    public Bucket.Updater updater() {
        return (key, mode) -> this.updater.apply(key, mode).orElseGet(() -> this.bucket.updater().update(key, mode));
    }

    @Override
    public Bucket.Lister lister() {
        return (prefix, offset) -> this.lister.apply(prefix, offset).orElseGet(() -> this.bucket.lister().list(prefix, offset));
    }
}

