/*
 * Copyright (C) 2024 Dremio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.projectnessie.objectstoragemock.adlsgen2;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;

@JsonSerialize(as = ImmutableDataLakeStorageError.class)
@JsonDeserialize(as = ImmutableDataLakeStorageError.class)
@Value.Immutable
// See
// https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/list?view=rest-storageservices-datalakestoragegen2-2019-12-12#datalakestorageerror
public interface DataLakeStorageError {
  DataLakeStorageErrorObj error();

  static DataLakeStorageError dataLakeStorageErrorObj(String code, String message) {
    return ImmutableDataLakeStorageError.of(ImmutableDataLakeStorageErrorObj.of(code, message));
  }
}
