/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.gcs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.gcs.ListResponse;
import org.projectnessie.objectstoragemock.gcs.StorageObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ListResponse", generator="Immutables")
@Immutable
public final class ImmutableListResponse
implements ListResponse {
    @Nullable
    private final String nextPageToken;
    private final List<String> prefixes;
    private final List<StorageObject> items;
    private transient int hashCode;

    private ImmutableListResponse(@Nullable String nextPageToken, Iterable<String> prefixes, Iterable<? extends StorageObject> items) {
        this.nextPageToken = nextPageToken;
        this.prefixes = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(prefixes, true, false));
        this.items = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(items, true, false));
    }

    private ImmutableListResponse(ImmutableListResponse original, @Nullable String nextPageToken, List<String> prefixes, List<StorageObject> items) {
        this.nextPageToken = nextPageToken;
        this.prefixes = prefixes;
        this.items = items;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> prefixes() {
        return this.prefixes;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<StorageObject> items() {
        return this.items;
    }

    public final ImmutableListResponse withNextPageToken(@Nullable String value) {
        if (Objects.equals(this.nextPageToken, value)) {
            return this;
        }
        return new ImmutableListResponse(this, value, this.prefixes, this.items);
    }

    public final ImmutableListResponse withPrefixes(String ... elements) {
        List<String> newValue = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListResponse(this, this.nextPageToken, newValue, this.items);
    }

    public final ImmutableListResponse withPrefixes(Iterable<String> elements) {
        if (this.prefixes == elements) {
            return this;
        }
        List<String> newValue = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(elements, true, false));
        return new ImmutableListResponse(this, this.nextPageToken, newValue, this.items);
    }

    public final ImmutableListResponse withItems(StorageObject ... elements) {
        List<StorageObject> newValue = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListResponse(this, this.nextPageToken, this.prefixes, newValue);
    }

    public final ImmutableListResponse withItems(Iterable<? extends StorageObject> elements) {
        if (this.items == elements) {
            return this;
        }
        List<StorageObject> newValue = ImmutableListResponse.createUnmodifiableList(false, ImmutableListResponse.createSafeList(elements, true, false));
        return new ImmutableListResponse(this, this.nextPageToken, this.prefixes, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListResponse && this.equalTo(0, (ImmutableListResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableListResponse another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.nextPageToken, another.nextPageToken) && this.prefixes.equals(another.prefixes) && this.items.equals(another.items);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nextPageToken);
        h += (h << 5) + this.prefixes.hashCode();
        h += (h << 5) + this.items.hashCode();
        return h;
    }

    public String toString() {
        return "ListResponse{nextPageToken=" + this.nextPageToken + ", prefixes=" + String.valueOf(this.prefixes) + ", items=" + String.valueOf(this.items) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListResponse fromJson(Json json) {
        Builder builder = ImmutableListResponse.builder();
        if (json.nextPageToken != null) {
            builder.nextPageToken(json.nextPageToken);
        }
        if (json.prefixes != null) {
            builder.addAllPrefixes(json.prefixes);
        }
        if (json.items != null) {
            builder.addAllItems(json.items);
        }
        return builder.build();
    }

    public static ImmutableListResponse of(@Nullable String nextPageToken, List<String> prefixes, List<StorageObject> items) {
        return ImmutableListResponse.of(nextPageToken, prefixes, items);
    }

    public static ImmutableListResponse of(@Nullable String nextPageToken, Iterable<String> prefixes, Iterable<? extends StorageObject> items) {
        return new ImmutableListResponse(nextPageToken, prefixes, items);
    }

    public static ImmutableListResponse copyOf(ListResponse instance) {
        if (instance instanceof ImmutableListResponse) {
            return (ImmutableListResponse)instance;
        }
        return ImmutableListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @javax.annotation.Nullable
        private String nextPageToken;
        private List<String> prefixes = new ArrayList<String>();
        private List<StorageObject> items = new ArrayList<StorageObject>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ListResponse instance) {
            Objects.requireNonNull(instance, "instance");
            String nextPageTokenValue = instance.nextPageToken();
            if (nextPageTokenValue != null) {
                this.nextPageToken(nextPageTokenValue);
            }
            this.addAllPrefixes(instance.prefixes());
            this.addAllItems(instance.items());
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder nextPageToken(@Nullable String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrefixe(String element) {
            this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrefixes(String ... elements) {
            for (String element : elements) {
                this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            }
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder prefixes(Iterable<String> elements) {
            this.prefixes.clear();
            return this.addAllPrefixes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPrefixes(Iterable<String> elements) {
            for (String element : elements) {
                this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItem(StorageObject element) {
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(StorageObject ... elements) {
            for (StorageObject element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder items(Iterable<? extends StorageObject> elements) {
            this.items.clear();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends StorageObject> elements) {
            for (StorageObject storageObject : elements) {
                this.items.add(Objects.requireNonNull(storageObject, "items element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.nextPageToken = null;
            this.prefixes.clear();
            this.items.clear();
            return this;
        }

        public ImmutableListResponse build() {
            return new ImmutableListResponse(null, this.nextPageToken, ImmutableListResponse.createUnmodifiableList(true, this.prefixes), ImmutableListResponse.createUnmodifiableList(true, this.items));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListResponse", generator="Immutables")
    static final class Json
    implements ListResponse {
        @javax.annotation.Nullable
        String nextPageToken;
        @javax.annotation.Nullable
        List<String> prefixes = Collections.emptyList();
        @javax.annotation.Nullable
        List<StorageObject> items = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setNextPageToken(@Nullable String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setPrefixes(List<String> prefixes) {
            this.prefixes = prefixes;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setItems(List<StorageObject> items) {
            this.items = items;
        }

        @Override
        public String nextPageToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> prefixes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StorageObject> items() {
            throw new UnsupportedOperationException();
        }
    }
}

