/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.s3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.s3.ObjectIdentifier;
import org.projectnessie.objectstoragemock.s3.S3ObjectIdentifier;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3ObjectIdentifier", generator="Immutables")
@Immutable
public final class ImmutableS3ObjectIdentifier
implements S3ObjectIdentifier {
    private final String key;
    @Nullable
    private final String versionId;

    private ImmutableS3ObjectIdentifier(String key, @Nullable String versionId) {
        this.key = Objects.requireNonNull(key, "key");
        this.versionId = versionId;
    }

    private ImmutableS3ObjectIdentifier(ImmutableS3ObjectIdentifier original, String key, @Nullable String versionId) {
        this.key = key;
        this.versionId = versionId;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="VersionId")
    @Nullable
    public String versionId() {
        return this.versionId;
    }

    public final ImmutableS3ObjectIdentifier withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableS3ObjectIdentifier(this, newValue, this.versionId);
    }

    public final ImmutableS3ObjectIdentifier withVersionId(@Nullable String value) {
        if (Objects.equals(this.versionId, value)) {
            return this;
        }
        return new ImmutableS3ObjectIdentifier(this, this.key, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3ObjectIdentifier && this.equalTo(0, (ImmutableS3ObjectIdentifier)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3ObjectIdentifier another) {
        return this.key.equals(another.key) && Objects.equals(this.versionId, another.versionId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.versionId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"S3ObjectIdentifier").omitNullValues().add("key", (Object)this.key).add("versionId", (Object)this.versionId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableS3ObjectIdentifier fromJson(Json json) {
        Builder builder = ImmutableS3ObjectIdentifier.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.versionId != null) {
            builder.versionId(json.versionId);
        }
        return builder.build();
    }

    public static ImmutableS3ObjectIdentifier of(String key, @Nullable String versionId) {
        return new ImmutableS3ObjectIdentifier(key, versionId);
    }

    public static ImmutableS3ObjectIdentifier copyOf(S3ObjectIdentifier instance) {
        if (instance instanceof ImmutableS3ObjectIdentifier) {
            return (ImmutableS3ObjectIdentifier)instance;
        }
        return ImmutableS3ObjectIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3ObjectIdentifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private String key;
        @javax.annotation.Nullable
        private String versionId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(S3ObjectIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String versionIdValue;
            ObjectIdentifier instance;
            long bits = 0L;
            if (object instanceof ObjectIdentifier) {
                instance = (ObjectIdentifier)object;
                if ((bits & 1L) == 0L) {
                    versionIdValue = instance.versionId();
                    if (versionIdValue != null) {
                        this.versionId(versionIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
            if (object instanceof S3ObjectIdentifier) {
                instance = (S3ObjectIdentifier)object;
                if ((bits & 1L) == 0L) {
                    versionIdValue = instance.versionId();
                    if (versionIdValue != null) {
                        this.versionId(versionIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="VersionId")
        @CanIgnoreReturnValue
        public final Builder versionId(@Nullable String versionId) {
            this.versionId = versionId;
            return this;
        }

        public ImmutableS3ObjectIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3ObjectIdentifier(null, this.key, this.versionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build S3ObjectIdentifier, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="S3ObjectIdentifier", generator="Immutables")
    static final class Json
    implements S3ObjectIdentifier {
        @javax.annotation.Nullable
        String key;
        @javax.annotation.Nullable
        String versionId;

        Json() {
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="VersionId")
        public void setVersionId(@Nullable String versionId) {
            this.versionId = versionId;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String versionId() {
            throw new UnsupportedOperationException();
        }
    }
}

