/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock.sts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.objectstoragemock.sts.AssumeRoleResult;
import org.projectnessie.objectstoragemock.sts.Credentials;
import org.projectnessie.objectstoragemock.sts.RoleUser;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AssumeRoleResult", generator="Immutables")
@Immutable
public final class ImmutableAssumeRoleResult
implements AssumeRoleResult {
    private final String sourceIdentity;
    private final RoleUser assumedRoleUser;
    private final Credentials credentials;

    private ImmutableAssumeRoleResult(String sourceIdentity, RoleUser assumedRoleUser, Credentials credentials) {
        this.sourceIdentity = sourceIdentity;
        this.assumedRoleUser = assumedRoleUser;
        this.credentials = credentials;
    }

    @Override
    @JsonProperty(value="SourceIdentity")
    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    @Override
    @JsonProperty(value="AssumedRoleUser")
    public RoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    @Override
    @JsonProperty(value="Credentials")
    public Credentials credentials() {
        return this.credentials;
    }

    public final ImmutableAssumeRoleResult withSourceIdentity(String value) {
        String newValue = Objects.requireNonNull(value, "sourceIdentity");
        if (this.sourceIdentity.equals(newValue)) {
            return this;
        }
        return new ImmutableAssumeRoleResult(newValue, this.assumedRoleUser, this.credentials);
    }

    public final ImmutableAssumeRoleResult withAssumedRoleUser(RoleUser value) {
        if (this.assumedRoleUser == value) {
            return this;
        }
        RoleUser newValue = Objects.requireNonNull(value, "assumedRoleUser");
        return new ImmutableAssumeRoleResult(this.sourceIdentity, newValue, this.credentials);
    }

    public final ImmutableAssumeRoleResult withCredentials(Credentials value) {
        if (this.credentials == value) {
            return this;
        }
        Credentials newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableAssumeRoleResult(this.sourceIdentity, this.assumedRoleUser, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAssumeRoleResult && this.equalTo(0, (ImmutableAssumeRoleResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAssumeRoleResult another) {
        return this.sourceIdentity.equals(another.sourceIdentity) && this.assumedRoleUser.equals(another.assumedRoleUser) && this.credentials.equals(another.credentials);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceIdentity.hashCode();
        h += (h << 5) + this.assumedRoleUser.hashCode();
        h += (h << 5) + this.credentials.hashCode();
        return h;
    }

    public String toString() {
        return "AssumeRoleResult{sourceIdentity=" + this.sourceIdentity + ", assumedRoleUser=" + String.valueOf(this.assumedRoleUser) + ", credentials=" + String.valueOf(this.credentials) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAssumeRoleResult fromJson(Json json) {
        Builder builder = ImmutableAssumeRoleResult.builder();
        if (json.sourceIdentity != null) {
            builder.sourceIdentity(json.sourceIdentity);
        }
        if (json.assumedRoleUser != null) {
            builder.assumedRoleUser(json.assumedRoleUser);
        }
        if (json.credentials != null) {
            builder.credentials(json.credentials);
        }
        return builder.build();
    }

    public static ImmutableAssumeRoleResult copyOf(AssumeRoleResult instance) {
        if (instance instanceof ImmutableAssumeRoleResult) {
            return (ImmutableAssumeRoleResult)instance;
        }
        return ImmutableAssumeRoleResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AssumeRoleResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_IDENTITY = 1L;
        private static final long INIT_BIT_ASSUMED_ROLE_USER = 2L;
        private static final long INIT_BIT_CREDENTIALS = 4L;
        private long initBits = 7L;
        @Nullable
        private String sourceIdentity;
        @Nullable
        private RoleUser assumedRoleUser;
        @Nullable
        private Credentials credentials;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AssumeRoleResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceIdentity(instance.sourceIdentity());
            this.assumedRoleUser(instance.assumedRoleUser());
            this.credentials(instance.credentials());
            return this;
        }

        @JsonProperty(value="SourceIdentity")
        @CanIgnoreReturnValue
        public final Builder sourceIdentity(String sourceIdentity) {
            this.sourceIdentity = Objects.requireNonNull(sourceIdentity, "sourceIdentity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="AssumedRoleUser")
        @CanIgnoreReturnValue
        public final Builder assumedRoleUser(RoleUser assumedRoleUser) {
            this.assumedRoleUser = Objects.requireNonNull(assumedRoleUser, "assumedRoleUser");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Credentials")
        @CanIgnoreReturnValue
        public final Builder credentials(Credentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAssumeRoleResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAssumeRoleResult(this.sourceIdentity, this.assumedRoleUser, this.credentials);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceIdentity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("assumedRoleUser");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("credentials");
            }
            return "Cannot build AssumeRoleResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AssumeRoleResult", generator="Immutables")
    static final class Json
    implements AssumeRoleResult {
        @Nullable
        String sourceIdentity;
        @Nullable
        RoleUser assumedRoleUser;
        @Nullable
        Credentials credentials;

        Json() {
        }

        @JsonProperty(value="SourceIdentity")
        public void setSourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
        }

        @JsonProperty(value="AssumedRoleUser")
        public void setAssumedRoleUser(RoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
        }

        @JsonProperty(value="Credentials")
        public void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public String sourceIdentity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RoleUser assumedRoleUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Credentials credentials() {
            throw new UnsupportedOperationException();
        }
    }
}

