/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.objectstoragemock;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.time.Instant;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.objectstoragemock.ImmutableBucket;
import org.projectnessie.objectstoragemock.MockObject;
import org.projectnessie.objectstoragemock.ObjectRetriever;

@Value.Immutable
public abstract class Bucket {
    public static ImmutableBucket.Builder builder() {
        return ImmutableBucket.builder();
    }

    @Value.Default
    public String creationDate() {
        return Instant.now().toString();
    }

    @Value.Default
    public ObjectRetriever object() {
        return x -> null;
    }

    @Value.Default
    public Deleter deleter() {
        return x -> false;
    }

    @Value.Default
    public Lister lister() {
        return (prefix, offset) -> Stream.empty();
    }

    @Value.Default
    public Updater updater() {
        return (objectName, mode) -> {
            throw new UnsupportedOperationException();
        };
    }

    @FunctionalInterface
    public static interface Deleter {
        public boolean delete(String var1);
    }

    @FunctionalInterface
    public static interface Lister {
        public Stream<ListElement> list(String var1, String var2);
    }

    @FunctionalInterface
    public static interface Updater {
        public ObjectUpdater update(String var1, UpdaterMode var2);
    }

    public static interface ListElement {
        public String key();

        public MockObject object();
    }

    public static interface ObjectUpdater {
        @CanIgnoreReturnValue
        public ObjectUpdater append(long var1, InputStream var3);

        @CanIgnoreReturnValue
        public ObjectUpdater flush();

        @CanIgnoreReturnValue
        public ObjectUpdater setContentType(String var1);

        @CanIgnoreReturnValue
        public MockObject commit();
    }

    public static enum UpdaterMode {
        CREATE_NEW,
        UPDATE,
        UPSERT;

    }
}

