/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.ByteString;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.quarkus.cli.ImmutableContentInfoEntry;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import picocli.CommandLine;

@CommandLine.Command(name="content-info", mixinStandardHelpOptions=true, description={"Get information about how content is stored for a given set of keys."})
public class ContentInfo
extends BaseCommand {
    @CommandLine.Option(names={"-o", "--output"}, description={"JSON output file name or '-' for STDOUT. If not set, per-key status is not reported."})
    private String outputSpec;
    @CommandLine.Option(names={"-k", "--key-element"}, description={"Elements or a specific content key to check (zero or more). If not set, all current keys will be reported."})
    private List<String> keyElements;
    @CommandLine.Option(names={"-B", "--batch"}, defaultValue="1000", description={"The maximum number of keys to process at the same time."})
    private int batchSize;
    @CommandLine.Option(names={"-r", "--ref"}, description={"Reference name to use (all branches, if not set)."})
    private String ref;
    @CommandLine.Option(names={"-H", "--hash"}, description={"Commit hash to use (defaults to the HEAD of the specified reference)."})
    private String hash;
    @CommandLine.Option(names={"-s", "--summary"}, description={"Print a summary of results to STDOUT (irrespective of the --output option)."})
    private boolean summary;
    private final AtomicInteger keysProcessed = new AtomicInteger();
    private final AtomicInteger activeGlobalStateEntries = new AtomicInteger();
    private final AtomicInteger missingContentFound = new AtomicInteger();

    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.warnOnInMemory();
        if (this.outputSpec != null) {
            if ("-".equals(this.outputSpec)) {
                this.check(this.spec.commandLine().getOut());
                this.spec.commandLine().getOut().println();
            } else {
                try (PrintWriter out = new PrintWriter(this.outputSpec, StandardCharsets.UTF_8);){
                    this.check(out);
                }
            }
        } else {
            this.check(new PrintWriter(OutputStream.nullOutputStream(), false, StandardCharsets.UTF_8));
        }
        if (this.summary) {
            this.spec.commandLine().getOut().printf("Processed %d keys: %d entries have global state; %d missing entries.%n", this.keysProcessed.get(), this.activeGlobalStateEntries.get(), this.missingContentFound.get());
        }
        return this.missingContentFound.get() > 0 ? 3 : 0;
    }

    private void check(PrintWriter out) throws Exception {
        JsonGenerator generator = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).getFactory().createGenerator((Writer)out);
        generator.writeStartArray();
        this.check(generator);
        generator.writeEndArray();
        generator.flush();
    }

    private void check(JsonGenerator generator) throws Exception {
        try (Stream<ReferenceInfo<ByteString>> heads = this.heads();){
            heads.forEach(head -> {
                try {
                    this.check(generator, (ReferenceInfo<ByteString>)head);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    private void check(JsonGenerator generator, ReferenceInfo<ByteString> head) throws Exception {
        if (this.keyElements != null && !this.keyElements.isEmpty()) {
            this.check(head, Collections.singleton(ContentKey.of(this.keyElements)), generator);
        } else {
            HashSet<ContentKey> batch = new HashSet<ContentKey>(this.batchSize);
            try (Stream keys = this.databaseAdapter.keys(head.getHash(), KeyFilterPredicate.ALLOW_ALL);){
                keys.forEach(keyListEntry -> {
                    batch.add(keyListEntry.getKey());
                    if (batch.size() >= this.batchSize) {
                        this.check(head, batch, generator);
                        batch.clear();
                    }
                });
            }
            if (!batch.isEmpty()) {
                this.check(head, batch, generator);
            }
        }
    }

    @MustBeClosed
    private Stream<ReferenceInfo<ByteString>> heads() throws ReferenceNotFoundException {
        if (this.hash != null) {
            return Stream.of(ReferenceInfo.of((Hash)Hash.of((String)this.hash), (NamedRef)DetachedRef.INSTANCE));
        }
        if (this.ref != null) {
            ReferenceInfo refInfo = this.databaseAdapter.namedRef(this.serverConfig.getDefaultBranch(), GetNamedRefsParams.DEFAULT);
            return Stream.of(refInfo);
        }
        return this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);
    }

    private void check(ReferenceInfo<ByteString> head, Set<ContentKey> keys, JsonGenerator generator) {
        try {
            AtomicInteger distanceFromHead = new AtomicInteger();
            try (Stream commitLog = this.databaseAdapter.commitLog(head.getHash());
                 Stream filteredLog = DatabaseAdapterUtil.takeUntilExcludeLast((Stream)commitLog, e -> keys.isEmpty());){
                filteredLog.forEach(commitLogEntry -> {
                    commitLogEntry.getPuts().forEach(keyWithBytes -> {
                        if (keys.remove(keyWithBytes.getKey())) {
                            this.report(generator, head.getNamedRef().getName(), keyWithBytes.getKey(), (KeyWithBytes)keyWithBytes, (CommitLogEntry)commitLogEntry, distanceFromHead.get(), null);
                        }
                    });
                    distanceFromHead.incrementAndGet();
                });
            }
        }
        catch (Exception e2) {
            keys.forEach(k -> this.report(generator, head.getNamedRef().getName(), (ContentKey)k, null, null, -1L, e2));
            return;
        }
        this.missingContentFound.addAndGet(keys.size());
        keys.forEach(k -> this.report(generator, head.getNamedRef().getName(), (ContentKey)k, null, null, -1L, new IllegalArgumentException("Missing content")));
    }

    private void report(JsonGenerator generator, String referenceName, ContentKey key, KeyWithBytes value, CommitLogEntry entry, long distanceFromHead, Throwable error) {
        this.keysProcessed.incrementAndGet();
        ImmutableContentInfoEntry.Builder builder = ImmutableContentInfoEntry.builder();
        builder.reference(referenceName);
        builder.key(ContentKey.of((List)key.getElements()));
        builder.distanceFromHead(distanceFromHead);
        if (entry != null) {
            builder.distanceFromRoot(entry.getCommitSeq());
            builder.hash(entry.getHash().asString());
        }
        Content.Type type = Content.Type.UNKNOWN;
        String storageModel = "UNKNOWN";
        if (error == null && entry != null) {
            try {
                type = DefaultStoreWorker.instance().getType(value.getPayload(), value.getValue());
                boolean globalState = DefaultStoreWorker.instance().requiresGlobalState(value.getPayload(), value.getValue());
                if (globalState) {
                    this.activeGlobalStateEntries.incrementAndGet();
                    storageModel = "GLOBAL_STATE";
                } else {
                    storageModel = "ON_REF_STATE";
                }
            }
            catch (Exception ex) {
                error = ex;
            }
        }
        builder.type(type);
        builder.storageModel(storageModel);
        if (error != null) {
            builder.errorMessage(error.getMessage());
            try (StringWriter wr = new StringWriter();
                 PrintWriter pw = new PrintWriter(wr);){
                error.printStackTrace(pw);
                pw.flush();
                builder.exceptionStackTrace(wr.toString());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            generator.writeObject((Object)builder.build());
            Object out = generator.getOutputTarget();
            if (out instanceof PrintWriter) {
                ((PrintWriter)out).println();
            }
            generator.flush();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

