/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.Map;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import picocli.CommandLine;

@CommandLine.Command(name="maintenance", mixinStandardHelpOptions=true, description={"Database adapter maintenance"})
public class RepoMaintenance
extends BaseCommand {
    @Override
    protected Integer callWithDatabaseAdapter() {
        this.warnOnInMemory();
        PrintWriter out = this.spec.commandLine().getOut();
        out.println("Running repository maintenance...");
        long t0 = System.nanoTime();
        Map statistics = this.databaseAdapter.repoMaintenance((RepoMaintenanceParams)RepoMaintenanceParams.builder().build());
        Duration duration = Duration.ofNanos(System.nanoTime() - t0);
        out.printf("Finished after %s%n", duration);
        statistics.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(top -> {
            out.printf("%nCategory '%s':%n", top.getKey());
            ((Map)top.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> String.format("    %-30s: %s", e.getKey(), e.getValue())).forEach(out::println);
        });
        return 0;
    }

    @Override
    protected Integer callWithPersist() {
        this.spec.commandLine().getOut().println("New Nessie storage does not need/provide any maintenance operations.");
        return 0;
    }
}

