/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.quarkus.cli.ImmutableCheckContentEntry;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.versionstore.ContentMapping;
import org.projectnessie.versioned.storage.versionstore.RefMapping;
import org.projectnessie.versioned.storage.versionstore.TypeMapping;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import picocli.CommandLine;

@CommandLine.Command(name="check-content", mixinStandardHelpOptions=true, description={"Check content readability of active keys."})
public class CheckContent
extends BaseCommand {
    @CommandLine.Option(names={"-o", "--output"}, description={"JSON output file name or '-' for STDOUT. If not set, per-key status is not reported."})
    private String outputSpec;
    @CommandLine.Option(names={"-k", "--key-element"}, description={"Elements or a specific content key to check (zero or more). If not set, all current keys will be checked."})
    private List<String> keyElements;
    @CommandLine.Option(names={"-c", "--show-content"}, description={"Include content for each valid key in the output."})
    private boolean showContent;
    @CommandLine.Option(names={"-B", "--batch"}, defaultValue="25", description={"The max number of keys to load at the same time.", "If an error occurs while loading or parsing the values for a single key, the error will be propagated to all keys processed in the same batch. In such a case, rerun the check for the affected keys with a batch size of 1."})
    private int batchSize;
    @CommandLine.Option(names={"-r", "--ref"}, description={"Reference name to use (default branch, if not set)."})
    private String ref;
    @CommandLine.Option(names={"-H", "--hash"}, description={"Commit hash to use (defaults to the HEAD of the specified reference)."})
    private String hash;
    @CommandLine.Option(names={"-s", "--summary"}, description={"Print a summary of results to STDOUT (irrespective of the --output option)."})
    private boolean summary;
    @CommandLine.Option(names={"-E", "--error-only"}, description={"Produce JSON only for keys with errors."})
    private boolean errorOnly;
    private final AtomicInteger keysProcessed = new AtomicInteger();
    private final AtomicInteger errorDetected = new AtomicInteger();
    private Ops ops;
    private JsonGenerator generator;

    @Override
    protected Integer callWithPersist() throws Exception {
        this.ops = new PersistOps();
        return this.check();
    }

    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.ops = new DatabaseAdapterOps();
        return this.check();
    }

    private Integer check() throws Exception {
        this.warnOnInMemory();
        if (this.outputSpec != null) {
            if ("-".equals(this.outputSpec)) {
                this.check(this.spec.commandLine().getOut());
                this.spec.commandLine().getOut().println();
            } else {
                try (PrintWriter out = new PrintWriter(this.outputSpec, StandardCharsets.UTF_8);){
                    this.check(out);
                }
            }
        } else {
            this.check(new PrintWriter(OutputStream.nullOutputStream(), false, StandardCharsets.UTF_8));
        }
        if (this.summary) {
            this.spec.commandLine().getOut().printf("Detected %d errors in %d keys.%n", this.errorDetected.get(), this.keysProcessed.get());
        }
        return this.errorDetected.get() == 0 ? 0 : EXIT_CODE_CONTENT_ERROR;
    }

    private void check(PrintWriter out) throws Exception {
        this.generator = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).getFactory().createGenerator((Writer)out);
        this.generator.writeStartArray();
        Hash hash = this.hash();
        if (this.keyElements != null && !this.keyElements.isEmpty()) {
            this.check(hash, List.of(ContentKey.of(this.keyElements)));
        } else {
            this.ops.iterateKeys(hash);
        }
        this.generator.writeEndArray();
        this.generator.flush();
    }

    private Hash hash() throws ReferenceNotFoundException {
        if (this.hash != null) {
            return Hash.of((String)this.hash);
        }
        String effectiveRef = this.ref;
        if (effectiveRef == null) {
            effectiveRef = this.serverConfig.getDefaultBranch();
        }
        return this.ops.resolveRefHead(effectiveRef);
    }

    private void check(Hash hash, List<ContentKey> keys) {
        Map<ContentKey, Content> values;
        try {
            values = this.ops.fetchValues(hash, keys);
        }
        catch (Exception e) {
            keys.forEach(k -> this.report((ContentKey)k, e, null));
            return;
        }
        keys.forEach(k -> {
            if (values.get(k) == null) {
                this.report((ContentKey)k, new IllegalArgumentException("Missing content"), null);
            }
        });
        values.forEach((k, value) -> {
            try {
                this.report((ContentKey)k, null, value);
            }
            catch (Exception e) {
                this.report((ContentKey)k, e, null);
            }
        });
    }

    private void report(ContentKey key, Throwable error, Object content) {
        this.keysProcessed.incrementAndGet();
        if (error != null) {
            this.errorDetected.incrementAndGet();
        }
        if (error == null && this.errorOnly) {
            return;
        }
        ImmutableCheckContentEntry.Builder builder = ImmutableCheckContentEntry.builder();
        builder.key(key);
        builder.status(error == null ? "OK" : "ERROR");
        if (error != null) {
            builder.errorMessage(error.getMessage());
            try (StringWriter wr = new StringWriter();
                 PrintWriter pw = new PrintWriter(wr);){
                error.printStackTrace(pw);
                pw.flush();
                builder.exceptionStackTrace(wr.toString());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        if (this.showContent && content instanceof Content) {
            builder.content((Content)content);
        }
        try {
            this.generator.writeObject((Object)builder.build());
            Object out = this.generator.getOutputTarget();
            if (out instanceof PrintWriter) {
                ((PrintWriter)out).println();
            }
            this.generator.flush();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    class DatabaseAdapterOps
    implements Ops {
        DatabaseAdapterOps() {
        }

        @Override
        public Hash resolveRefHead(String effectiveRef) throws ReferenceNotFoundException {
            return CheckContent.this.databaseAdapter.namedRef(effectiveRef, GetNamedRefsParams.DEFAULT).getHash();
        }

        @Override
        public void iterateKeys(Hash hash) throws ReferenceNotFoundException {
            ArrayList<ContentKey> batch = new ArrayList<ContentKey>(CheckContent.this.batchSize);
            try (Stream keys = CheckContent.this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL);){
                keys.forEach(keyListEntry -> {
                    batch.add(keyListEntry.getKey());
                    if (batch.size() >= CheckContent.this.batchSize) {
                        CheckContent.this.check(hash, batch);
                        batch.clear();
                    }
                });
            }
            CheckContent.this.check(hash, batch);
        }

        @Override
        public Map<ContentKey, Content> fetchValues(Hash hash, List<ContentKey> keys) throws ReferenceNotFoundException {
            return CheckContent.this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().map(entry -> Map.entry((ContentKey)entry.getKey(), DefaultStoreWorker.instance().valueFromStore((int)((ContentAndState)entry.getValue()).getPayload(), ((ContentAndState)entry.getValue()).getRefState(), () -> ((ContentAndState)((ContentAndState)entry.getValue())).getGlobalState()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    class PersistOps
    implements Ops {
        private StoreIndex<CommitOp> index;

        PersistOps() {
        }

        @Override
        public Hash resolveRefHead(String effectiveRef) throws ReferenceNotFoundException {
            return TypeMapping.objIdToHash((ObjId)new RefMapping(CheckContent.this.persist).resolveNamedRef(effectiveRef).pointer());
        }

        @Override
        public void iterateKeys(Hash hash) throws ReferenceNotFoundException {
            ArrayList<ContentKey> batch = new ArrayList<ContentKey>(CheckContent.this.batchSize);
            this.index(hash).iterator(null, null, true).forEachRemaining(indexElement -> {
                if (((CommitOp)indexElement.content()).action().exists()) {
                    ContentKey key = TypeMapping.storeKeyToKey((StoreKey)indexElement.key());
                    batch.add(key);
                    if (batch.size() >= CheckContent.this.batchSize) {
                        CheckContent.this.check(hash, batch);
                        batch.clear();
                    }
                }
            });
            CheckContent.this.check(hash, batch);
        }

        @Override
        public Map<ContentKey, Content> fetchValues(Hash hash, List<ContentKey> keys) throws ReferenceNotFoundException {
            this.index(hash).loadIfNecessary(keys.stream().map(TypeMapping::keyToStoreKey).collect(Collectors.toSet()));
            HashMap<ObjId, ContentKey> idsToKeys = new HashMap<ObjId, ContentKey>(keys.size());
            for (ContentKey key : keys) {
                StoreKey storeKey = TypeMapping.keyToStoreKey((ContentKey)key);
                StoreIndexElement indexElement = this.index.get(storeKey);
                if (indexElement == null || !((CommitOp)indexElement.content()).action().exists()) continue;
                idsToKeys.put(Objects.requireNonNull(((CommitOp)indexElement.content()).value(), "Required value pointer is null"), key);
            }
            ContentMapping contentMapping = new ContentMapping(CheckContent.this.persist);
            try {
                return contentMapping.fetchContents(idsToKeys);
            }
            catch (ObjNotFoundException e) {
                throw RefMapping.objectNotFound((ObjNotFoundException)e);
            }
        }

        private StoreIndex<CommitOp> index(Hash hash) throws ReferenceNotFoundException {
            if (this.index == null) {
                try {
                    CommitObj c = Logics.commitLogic((Persist)CheckContent.this.persist).fetchCommit(TypeMapping.hashToObjId((Hash)hash));
                    this.index = Logics.indexesLogic((Persist)CheckContent.this.persist).buildCompleteIndexOrEmpty(c);
                }
                catch (ObjNotFoundException e) {
                    throw RefMapping.hashNotFound((Hash)hash);
                }
            }
            return this.index;
        }
    }

    static interface Ops {
        public Hash resolveRefHead(String var1) throws ReferenceNotFoundException;

        public void iterateKeys(Hash var1) throws ReferenceNotFoundException;

        public Map<ContentKey, Content> fetchValues(Hash var1, List<ContentKey> var2) throws ReferenceNotFoundException;
    }
}

