/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Nessie repository information"})
public class NessieInfo
extends BaseCommand {
    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.warnOnInMemory();
        ReferenceInfo refInfo = this.databaseAdapter.namedRef(this.serverConfig.getDefaultBranch(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build());
        RepoDescription repoDesc = this.databaseAdapter.fetchRepositoryDescription();
        this.spec.commandLine().getOut().printf("%nNo-ancestor hash:                  %s%nDefault branch head commit ID:     %s%nDefault branch commit count:       %s%nRepository description version:    %d%nRepository description properties: %s%n%nFrom configuration:%n-------------------%nVersion-store type:                %s%nDefault branch:                    %s%n", this.databaseAdapter.noAncestorHash().asString(), refInfo.getHash().asString(), refInfo.getCommitSeq(), repoDesc.getRepoVersion(), repoDesc.getProperties().entrySet().stream().map(e -> String.format("%-30s = %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n                                   ")), this.versionStoreConfig.getVersionStoreType(), this.serverConfig.getDefaultBranch());
        return 0;
    }

    @Override
    protected Integer callWithPersist() throws Exception {
        this.warnOnInMemory();
        if (!Logics.repositoryLogic((Persist)this.persist).repositoryExists()) {
            this.spec.commandLine().getErr().println("Nessie repository does not exist");
            return EXIT_CODE_REPO_DOES_NOT_EXIST;
        }
        ReferenceLogic referenceLogic = Logics.referenceLogic((Persist)this.persist);
        Reference defaultBranch = referenceLogic.getReference("refs/heads/" + this.serverConfig.getDefaultBranch());
        CommitLogic commitLogic = Logics.commitLogic((Persist)this.persist);
        CommitObj headCommit = commitLogic.fetchCommit(defaultBranch.pointer());
        Reference refRepo = this.persist.fetchReference(InternalRef.REF_REPO.name());
        CommitObj repoCommit = refRepo != null ? commitLogic.fetchCommit(refRepo.pointer()) : null;
        this.spec.commandLine().getOut().printf("%nRepository created:                %s%nDefault branch head commit ID:     %s%nDefault branch commit count:       %s%n%nFrom configuration:%n-------------------%nVersion-store type:                %s%nDefault branch:                    %s%nParent commit IDs per commit:      %s%n", repoCommit != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis(repoCommit.created())), ZoneId.systemDefault()) : "???", defaultBranch.pointer(), headCommit != null ? headCommit.seq() : 0L, this.versionStoreConfig.getVersionStoreType(), this.serverConfig.getDefaultBranch(), this.persist.config().parentsPerCommit());
        return 0;
    }
}

