/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.projectnessie.quarkus.config.VersionStoreConfig;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.storage.common.persist.Persist;
import picocli.CommandLine;

public abstract class BaseCommand
implements Callable<Integer> {
    DatabaseAdapter databaseAdapter;
    Persist persist;
    @Inject
    VersionStoreConfig versionStoreConfig;
    @Inject
    ServerConfig serverConfig;
    @Inject
    Instance<DatabaseAdapter> databaseAdapterInstance;
    @Inject
    Instance<Persist> persistInstance;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    public static final Integer EXIT_CODE_GENERIC_ERROR = 1;
    public static final Integer EXIT_CODE_CONTENT_ERROR = 3;
    public static final Integer EXIT_CODE_REPO_DOES_NOT_EXIST = 4;
    public static final Integer EXIT_CODE_REPO_ALREADY_EXISTS = 100;

    @Override
    public final Integer call() throws Exception {
        VersionStoreConfig.VersionStoreType versionStoreType = this.versionStoreConfig.getVersionStoreType();
        if (versionStoreType.isNewStorage()) {
            this.persist = (Persist)this.persistInstance.select(new Annotation[]{Default.Literal.INSTANCE}).get();
            return this.callWithPersist();
        }
        this.databaseAdapter = (DatabaseAdapter)this.databaseAdapterInstance.get();
        return this.callWithDatabaseAdapter();
    }

    protected Integer callWithPersist() throws Exception {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("Command '" + this.spec.name() + "' is not (yet) supported for new Nessie storage."));
        return EXIT_CODE_GENERIC_ERROR;
    }

    protected Integer callWithDatabaseAdapter() throws Exception {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("Command '" + this.spec.name() + "' is not (yet) supported for old Nessie storage."));
        return EXIT_CODE_GENERIC_ERROR;
    }

    protected void warnOnInMemory() {
        if (this.versionStoreConfig.getVersionStoreType() == VersionStoreConfig.VersionStoreType.INMEMORY || this.versionStoreConfig.getVersionStoreType() == VersionStoreConfig.VersionStoreType.IN_MEMORY) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("****************************************************************************************\n** Repository information & maintenance for an in-memory implementation is meaningless\n****************************************************************************************\n"));
        }
    }
}

