/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Persist;
import picocli.CommandLine;

@CommandLine.Command(name="erase-repository", mixinStandardHelpOptions=true, description={"Erase current Nessie repository (all data will be lost) and optionally re-initialize it."})
public class EraseRepository
extends BaseCommand {
    @CommandLine.Option(names={"-r", "--re-initialize"}, description={"Re-initialize the repository after erasure. If set, provides the default branch name for the new repository."})
    private String newDefaultBranch;
    @CommandLine.Option(names={"--confirmation-code"}, description={"Confirmation code for erasing the repository (will be emitted by this command if not set)."})
    private String confirmationCode;

    @Override
    public Integer call() {
        this.warnOnInMemory();
        if (!Logics.repositoryLogic((Persist)this.persist).repositoryExists()) {
            this.spec.commandLine().getErr().println("Nessie repository does not exist");
            return EXIT_CODE_REPO_DOES_NOT_EXIST;
        }
        String code = EraseRepository.getConfirmationCode(this.persist);
        if (!code.equals(this.confirmationCode)) {
            this.spec.commandLine().getErr().printf("Please use the '--confirmation-code=%s' option to indicate that the repository erasure operation is intentional.%nAll Nessie data will be lost!%n", code);
            return EXIT_CODE_GENERIC_ERROR;
        }
        this.persist.erase();
        this.spec.commandLine().getOut().println("Repository erased.");
        if (this.newDefaultBranch != null) {
            Logics.repositoryLogic((Persist)this.persist).initialize(this.newDefaultBranch);
            this.spec.commandLine().getOut().println("Repository initialized.");
        }
        return 0;
    }

    static String getConfirmationCode(Persist persist) {
        StoreConfig config = persist.config();
        long code = config.repositoryId().hashCode();
        ++code;
        RepositoryLogic repositoryLogic = Logics.repositoryLogic((Persist)persist);
        RepositoryDescription repoDesc = repositoryLogic.fetchRepositoryDescription();
        if (repoDesc != null) {
            code = code * 31L + repoDesc.repositoryCreatedTime().toEpochMilli();
            code = code * 31L + repoDesc.oldestPossibleCommitTime().toEpochMilli();
        }
        code = 31L * code + (long)config.parentsPerCommit();
        code = 31L * code + (long)config.maxIncrementalIndexSize();
        code = 31L * code + (long)config.maxSerializedIndexSize();
        code = Math.abs(code);
        return Long.toString(code, 36);
    }
}

