/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.projectnessie.quarkus.config.VersionStoreConfig;
import org.projectnessie.quarkus.providers.UninitializedRepository;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.storage.common.persist.Persist;
import picocli.CommandLine;

public abstract class BaseCommand
implements Callable<Integer> {
    @Inject
    @UninitializedRepository
    Persist persist;
    @Inject
    VersionStoreConfig versionStoreConfig;
    @Inject
    ServerConfig serverConfig;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    public static final Integer EXIT_CODE_GENERIC_ERROR = 1;
    public static final Integer EXIT_CODE_CONTENT_ERROR = 3;
    public static final Integer EXIT_CODE_REPO_DOES_NOT_EXIST = 4;
    public static final Integer EXIT_CODE_REPO_ALREADY_EXISTS = 100;

    @Override
    public abstract Integer call() throws Exception;

    protected void warnOnInMemory() {
        if (this.versionStoreConfig.getVersionStoreType() == VersionStoreConfig.VersionStoreType.IN_MEMORY) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("****************************************************************************************\n** Repository information & maintenance for an in-memory implementation is meaningless\n****************************************************************************************\n"));
        }
    }
}

