/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import jakarta.annotation.Nonnull;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.FileImporter;
import org.projectnessie.versioned.transfer.files.ImportFileSupplier;
import org.projectnessie.versioned.transfer.files.ZipArchiveImporter;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;
import picocli.CommandLine;

@CommandLine.Command(name="import", mixinStandardHelpOptions=true, description={"Imports a Nessie repository from the local file system."})
public class ImportRepository
extends BaseCommand {
    static final String PATH = "--path";
    static final String ERASE_BEFORE_IMPORT = "--erase-before-import";
    static final String INPUT_BUFFER_SIZE = "--input-buffer-size";
    static final String COMMIT_BATCH_SIZE = "--commit-batch-size";
    @CommandLine.Option(names={"-p", "--path"}, paramLabel="<import-from>", required=true, description={"The ZIP file or directory to read the export from.", "If this parameter refers to a file, the import will assume that it is a ZIP file, otherwise a directory."})
    private Path path;
    @CommandLine.Option(names={"--commit-batch-size"}, description={"Batch size when writing commits, defaults to 20."})
    private Integer commitBatchSize;
    @CommandLine.Option(names={"--input-buffer-size"}, description={"Input buffer size, defaults to 32768."})
    private Integer inputBufferSize;
    @CommandLine.Option(names={"-e", "--erase-before-import"}, description={"Erase an existing repository before the import is started.", "This will delete all previously existing Nessie data.", "Using this option has no effect, if the Nessie repository does not already exist."})
    private boolean erase;

    /*
     * Exception decompiling
     */
    @Override
    public Integer call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ImportFileSupplier createImportFileSupplier() {
        ZipArchiveImporter importFileSupplier;
        if (Files.isRegularFile(this.path, new LinkOption[0])) {
            importFileSupplier = ZipArchiveImporter.builder().sourceZipFile(this.path).build();
        } else if (Files.isDirectory(this.path, new LinkOption[0])) {
            FileImporter.Builder b = FileImporter.builder().sourceDirectory(this.path);
            if (this.inputBufferSize != null) {
                b.inputBufferSize(this.inputBufferSize.intValue());
            }
            importFileSupplier = b.build();
        } else {
            throw new CommandLine.PicocliException(String.format("No such file or directory %s", this.path));
        }
        return importFileSupplier;
    }

    private static final class ImportProgressListener
    implements ProgressListener {
        private final PrintWriter out;
        private int count;
        private boolean dot;
        private TransferTypes.ExportMeta exportMeta;
        private long timeOffset;
        private long timeLast;

        public ImportProgressListener(PrintWriter out) {
            this.out = out;
        }

        public void progress(@Nonnull ProgressEvent progress, TransferTypes.ExportMeta meta) {
            switch (progress) {
                case START_PREPARE: {
                    this.out.printf("Preparing repository...%n", new Object[0]);
                    this.dot = false;
                    break;
                }
                case END_PREPARE: {
                    break;
                }
                case END_META: {
                    this.exportMeta = meta;
                    String nessieVersion = meta.getNessieVersion();
                    if (nessieVersion.isEmpty()) {
                        nessieVersion = "(unknown, before 0.46)";
                    }
                    this.out.printf("Export was created by Nessie version %s on %s, containing %d named references (in %d files) and %d commits (in %d files).%n", nessieVersion, Instant.ofEpochMilli(meta.getCreatedMillisEpoch()), meta.getNamedReferencesCount(), meta.getNamedReferencesFilesCount(), meta.getCommitCount(), meta.getCommitsFilesCount());
                    break;
                }
                case START_COMMITS: {
                    this.out.printf("Importing %d commits...%n", this.exportMeta.getCommitCount());
                    this.startPhase();
                    break;
                }
                case END_COMMITS: {
                    this.endPhase();
                    this.out.printf("%d commits imported, total duration: %s.%n%n", this.count, this.totalDuration());
                    break;
                }
                case START_NAMED_REFERENCES: {
                    this.out.printf("Importing %d named references...%n", this.exportMeta.getNamedReferencesCount());
                    this.startPhase();
                    break;
                }
                case COMMIT_WRITTEN: 
                case NAMED_REFERENCE_WRITTEN: 
                case FINALIZE_PROGRESS: {
                    long now;
                    ++this.count;
                    if (this.count % 10 == 0) {
                        this.out.print('.');
                        this.out.flush();
                        this.dot = true;
                    }
                    if (this.count % 1000 != 0) break;
                    long last = this.timeLast;
                    this.timeLast = now = System.nanoTime();
                    this.out.printf(" %d - duration: %s%n", this.count, Duration.ofNanos(now - last));
                    this.dot = false;
                    break;
                }
                case END_NAMED_REFERENCES: {
                    this.endPhase();
                    this.out.printf("%d named references imported, total duration: %s.%n%n", this.count, this.totalDuration());
                    break;
                }
                case START_FINALIZE: {
                    this.out.printf("Finalizing import...%n", new Object[0]);
                    this.startPhase();
                    break;
                }
                case END_FINALIZE: {
                    this.endPhase();
                    this.out.printf("Import finalization finished, total duration: %s.%n%n", this.totalDuration());
                    break;
                }
            }
        }

        private Duration totalDuration() {
            return Duration.ofNanos(System.nanoTime() - this.timeOffset);
        }

        private void startPhase() {
            this.count = 0;
            this.timeLast = this.timeOffset = System.nanoTime();
            this.dot = false;
        }

        private void endPhase() {
            if (this.dot) {
                this.out.println();
            }
        }
    }
}

