/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Nessie repository information"})
public class NessieInfo
extends BaseCommand {
    @Override
    public Integer call() throws Exception {
        this.warnOnInMemory();
        if (!Logics.repositoryLogic((Persist)this.persist).repositoryExists()) {
            this.spec.commandLine().getErr().println("Nessie repository does not exist");
            return EXIT_CODE_REPO_DOES_NOT_EXIST;
        }
        ReferenceLogic referenceLogic = Logics.referenceLogic((Persist)this.persist);
        Reference defaultBranch = referenceLogic.getReference("refs/heads/" + this.serverConfig.getDefaultBranch());
        CommitLogic commitLogic = Logics.commitLogic((Persist)this.persist);
        CommitObj headCommit = commitLogic.fetchCommit(defaultBranch.pointer());
        Reference refRepo = this.persist.fetchReference(InternalRef.REF_REPO.name());
        CommitObj repoCommit = refRepo != null ? commitLogic.fetchCommit(refRepo.pointer()) : null;
        this.spec.commandLine().getOut().printf("%nRepository created:                %s%nDefault branch head commit ID:     %s%nDefault branch commit count:       %s%n%nFrom configuration:%n-------------------%nVersion-store type:                %s%nDefault branch:                    %s%nParent commit IDs per commit:      %s%n", repoCommit != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis(repoCommit.created())), ZoneId.systemDefault()) : "???", defaultBranch.pointer(), headCommit != null ? headCommit.seq() : 0L, this.versionStoreConfig.getVersionStoreType(), this.serverConfig.getDefaultBranch(), this.persist.config().parentsPerCommit());
        return 0;
    }
}

