/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.distcache;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.vertx.http.ManagementInterface;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.projectnessie.quarkus.config.QuarkusStoreConfig;
import org.projectnessie.quarkus.providers.ServerInstanceId;
import org.projectnessie.server.distcache.CacheInvalidations;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidation;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidationConsumer;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheInvalidationReceiver
implements DistributedCacheInvalidationConsumer {
    public static final String NESSIE_CACHE_INVALIDATION_TOKEN_HEADER = "Nessie-Cache-Invalidation-Token";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheInvalidationReceiver.class);
    private DistributedCacheInvalidation distributedCacheInvalidation;
    private final String serverInstanceId;
    private final Set<String> validTokens;
    private final String invalidationPath;
    private final ObjectMapper objectMapper;

    @Inject
    public CacheInvalidationReceiver(QuarkusStoreConfig storeConfig, @ServerInstanceId String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
        this.invalidationPath = storeConfig.cacheInvalidationUri();
        this.validTokens = new HashSet<String>(storeConfig.cacheInvalidationValidTokens().orElse(Collections.emptyList()));
        this.objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public void applyDistributedCacheInvalidation(DistributedCacheInvalidation distributedCacheInvalidation) {
        this.distributedCacheInvalidation = distributedCacheInvalidation;
    }

    public void registerManagementRoutes(@Observes ManagementInterface mi) {
        mi.router().post(this.invalidationPath).handler(this::cacheInvalidations);
    }

    void cacheInvalidations(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        String senderId = request.getParam("sender");
        String token = request.getHeader(NESSIE_CACHE_INVALIDATION_TOKEN_HEADER);
        this.cacheInvalidations(rc, () -> {
            try {
                String json = rc.body().asString();
                if (json == null || json.isEmpty()) {
                    return CacheInvalidations.cacheInvalidations(Collections.emptyList());
                }
                return (CacheInvalidations)this.objectMapper.readValue(json, CacheInvalidations.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, senderId, token);
    }

    void cacheInvalidations(RoutingContext rc, Supplier<CacheInvalidations> invalidations, String senderId, String token) {
        List<CacheInvalidations.CacheInvalidation> invs;
        if (token == null || !this.validTokens.contains(token)) {
            LOGGER.warn("Received cache invalidation with invalid token {}", (Object)token);
            this.responseInvalidToken(rc);
            return;
        }
        if (this.serverInstanceId.equals(senderId)) {
            LOGGER.trace("Ignoring invalidations from local instance");
            this.responseNoContent(rc);
            return;
        }
        if (!"application/json".equals(rc.request().getHeader("Content-Type"))) {
            LOGGER.warn("Received cache invalidation with invalid HTTP content type");
            this.responseInvalidContentType(rc);
            return;
        }
        try {
            invs = invalidations.get().invalidations();
        }
        catch (RuntimeException e) {
            this.responseServerError(rc);
            return;
        }
        DistributedCacheInvalidation cacheInvalidation = this.distributedCacheInvalidation;
        if (cacheInvalidation != null) {
            for (CacheInvalidations.CacheInvalidation invalidation : invs) {
                switch (invalidation.type()) {
                    case "obj": {
                        CacheInvalidations.CacheInvalidationEvictObj putObj = (CacheInvalidations.CacheInvalidationEvictObj)invalidation;
                        cacheInvalidation.evictObj(putObj.repoId(), ObjId.objIdFromByteArray((byte[])putObj.id()));
                        break;
                    }
                    case "ref": {
                        CacheInvalidations.CacheInvalidationEvictReference putReference = (CacheInvalidations.CacheInvalidationEvictReference)invalidation;
                        cacheInvalidation.evictReference(putReference.repoId(), putReference.refName());
                        break;
                    }
                }
            }
        }
        this.responseNoContent(rc);
    }

    private void responseServerError(RoutingContext rc) {
        rc.response().setStatusCode(500).setStatusMessage("Server error parsing request body").end();
    }

    private void responseInvalidToken(RoutingContext rc) {
        rc.response().setStatusCode(400).setStatusMessage("Invalid token").end();
    }

    private void responseInvalidContentType(RoutingContext rc) {
        rc.response().setStatusCode(415).setStatusMessage("Unsupported media type").end();
    }

    private void responseNoContent(RoutingContext rc) {
        rc.response().setStatusCode(204).setStatusMessage("No content").end();
    }
}

