/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.distcache;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.server.distcache.ImmutableCacheInvalidationEvictObj;
import org.projectnessie.server.distcache.ImmutableCacheInvalidationEvictReference;
import org.projectnessie.server.distcache.ImmutableCacheInvalidations;

@JsonSerialize(as=ImmutableCacheInvalidations.class)
@JsonDeserialize(as=ImmutableCacheInvalidations.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface CacheInvalidations {
    @Value.Parameter(order=1)
    public List<CacheInvalidation> invalidations();

    public static CacheInvalidations cacheInvalidations(List<CacheInvalidation> invalidations) {
        return ImmutableCacheInvalidations.of(invalidations);
    }

    @JsonSerialize(as=ImmutableCacheInvalidationEvictReference.class)
    @JsonDeserialize(as=ImmutableCacheInvalidationEvictReference.class)
    @JsonTypeName(value="ref")
    @Value.Immutable
    public static interface CacheInvalidationEvictReference
    extends CacheInvalidation {
        public static final String TYPE = "ref";

        @Override
        default public String type() {
            return TYPE;
        }

        @Override
        @Value.Parameter(order=1)
        public String repoId();

        @JsonProperty(value="ref")
        @Value.Parameter(order=2)
        public String refName();

        public static CacheInvalidationEvictReference cacheInvalidationEvictReference(String repoId, String refName) {
            return ImmutableCacheInvalidationEvictReference.of(repoId, refName);
        }
    }

    @JsonSerialize(as=ImmutableCacheInvalidationEvictObj.class)
    @JsonDeserialize(as=ImmutableCacheInvalidationEvictObj.class)
    @JsonTypeName(value="obj")
    @Value.Immutable
    public static interface CacheInvalidationEvictObj
    extends CacheInvalidation {
        public static final String TYPE = "obj";

        @Override
        default public String type() {
            return TYPE;
        }

        @Override
        @Value.Parameter(order=1)
        public String repoId();

        @Value.Parameter(order=2)
        public byte[] id();

        public static CacheInvalidationEvictObj cacheInvalidationEvictObj(String repoId, byte[] id) {
            return ImmutableCacheInvalidationEvictObj.of(repoId, id);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="t")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CacheInvalidationEvictObj.class, name="obj"), @JsonSubTypes.Type(value=CacheInvalidationEvictReference.class, name="ref")})
    public static interface CacheInvalidation {
        public String type();

        @JsonProperty(value="r")
        public String repoId();
    }
}

