/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.CompletedPart;
import org.projectnessie.s3mock.data.CompletedPartBase;
import org.projectnessie.s3mock.data.EtagDeserializer;
import org.projectnessie.s3mock.data.EtagSerializer;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CompletedPart", generator="Immutables")
@Immutable
public final class ImmutableCompletedPart
implements CompletedPart {
    private final Integer partNumber;
    private final String etag;

    private ImmutableCompletedPart(Integer partNumber, String etag) {
        this.partNumber = partNumber;
        this.etag = etag;
    }

    @Override
    @JsonProperty(value="PartNumber")
    public Integer partNumber() {
        return this.partNumber;
    }

    @Override
    @JsonProperty(value="ETag")
    @JsonSerialize(using=EtagSerializer.class)
    @JsonDeserialize(using=EtagDeserializer.class)
    public String etag() {
        return this.etag;
    }

    public final ImmutableCompletedPart withPartNumber(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "partNumber");
        if (this.partNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableCompletedPart(newValue, this.etag);
    }

    public final ImmutableCompletedPart withEtag(String value) {
        String newValue = Objects.requireNonNull(value, "etag");
        if (this.etag.equals(newValue)) {
            return this;
        }
        return new ImmutableCompletedPart(this.partNumber, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompletedPart && this.equalTo(0, (ImmutableCompletedPart)another);
    }

    private boolean equalTo(int synthetic, ImmutableCompletedPart another) {
        return this.partNumber.equals(another.partNumber) && this.etag.equals(another.etag);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.partNumber.hashCode();
        h += (h << 5) + this.etag.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CompletedPart").omitNullValues().add("partNumber", (Object)this.partNumber).add("etag", (Object)this.etag).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCompletedPart fromJson(Json json) {
        Builder builder = ImmutableCompletedPart.builder();
        if (json.partNumber != null) {
            builder.partNumber(json.partNumber);
        }
        if (json.etag != null) {
            builder.etag(json.etag);
        }
        return builder.build();
    }

    public static ImmutableCompletedPart copyOf(CompletedPart instance) {
        if (instance instanceof ImmutableCompletedPart) {
            return (ImmutableCompletedPart)instance;
        }
        return ImmutableCompletedPart.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CompletedPart", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PART_NUMBER = 1L;
        private static final long INIT_BIT_ETAG = 2L;
        private long initBits = 3L;
        @Nullable
        private Integer partNumber;
        @Nullable
        private String etag;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompletedPart instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CompletedPartBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CompletedPartBase instance;
            long bits = 0L;
            if (object instanceof CompletedPart) {
                instance = (CompletedPart)object;
                if ((bits & 1L) == 0L) {
                    this.partNumber(instance.partNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.etag(instance.etag());
                    bits |= 2L;
                }
            }
            if (object instanceof CompletedPartBase) {
                instance = (CompletedPartBase)object;
                if ((bits & 1L) == 0L) {
                    this.partNumber(instance.partNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.etag(instance.etag());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="PartNumber")
        @CanIgnoreReturnValue
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = Objects.requireNonNull(partNumber, "partNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ETag")
        @JsonSerialize(using=EtagSerializer.class)
        @JsonDeserialize(using=EtagDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag, "etag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCompletedPart build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompletedPart(this.partNumber, this.etag);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("partNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("etag");
            }
            return "Cannot build CompletedPart, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CompletedPart", generator="Immutables")
    static final class Json
    implements CompletedPart {
        @Nullable
        Integer partNumber;
        @Nullable
        String etag;

        Json() {
        }

        @JsonProperty(value="PartNumber")
        public void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @JsonProperty(value="ETag")
        @JsonSerialize(using=EtagSerializer.class)
        @JsonDeserialize(using=EtagDeserializer.class)
        public void setEtag(String etag) {
            this.etag = etag;
        }

        @Override
        public Integer partNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String etag() {
            throw new UnsupportedOperationException();
        }
    }
}

