/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.DeletedS3Object;
import org.projectnessie.s3mock.data.ObjectIdentifier;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeletedS3Object", generator="Immutables")
@Immutable
public final class ImmutableDeletedS3Object
implements DeletedS3Object {
    private final String key;
    @Nullable
    private final String versionId;
    @Nullable
    private final Boolean deleteMarker;
    @Nullable
    private final String deleteMarkerVersionId;

    private ImmutableDeletedS3Object(String key, @Nullable String versionId) {
        this.key = Objects.requireNonNull(key, "key");
        this.versionId = versionId;
        this.deleteMarker = null;
        this.deleteMarkerVersionId = null;
    }

    private ImmutableDeletedS3Object(String key, @Nullable String versionId, @Nullable Boolean deleteMarker, @Nullable String deleteMarkerVersionId) {
        this.key = key;
        this.versionId = versionId;
        this.deleteMarker = deleteMarker;
        this.deleteMarkerVersionId = deleteMarkerVersionId;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="VersionId")
    @Nullable
    public String versionId() {
        return this.versionId;
    }

    @Override
    @JsonProperty(value="DeleteMarker")
    @Nullable
    public Boolean deleteMarker() {
        return this.deleteMarker;
    }

    @Override
    @JsonProperty(value="DeleteMarkerVersionId")
    @Nullable
    public String deleteMarkerVersionId() {
        return this.deleteMarkerVersionId;
    }

    public final ImmutableDeletedS3Object withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableDeletedS3Object(newValue, this.versionId, this.deleteMarker, this.deleteMarkerVersionId);
    }

    public final ImmutableDeletedS3Object withVersionId(@Nullable String value) {
        if (Objects.equals(this.versionId, value)) {
            return this;
        }
        return new ImmutableDeletedS3Object(this.key, value, this.deleteMarker, this.deleteMarkerVersionId);
    }

    public final ImmutableDeletedS3Object withDeleteMarker(@Nullable Boolean value) {
        if (Objects.equals(this.deleteMarker, value)) {
            return this;
        }
        return new ImmutableDeletedS3Object(this.key, this.versionId, value, this.deleteMarkerVersionId);
    }

    public final ImmutableDeletedS3Object withDeleteMarkerVersionId(@Nullable String value) {
        if (Objects.equals(this.deleteMarkerVersionId, value)) {
            return this;
        }
        return new ImmutableDeletedS3Object(this.key, this.versionId, this.deleteMarker, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletedS3Object && this.equalTo(0, (ImmutableDeletedS3Object)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeletedS3Object another) {
        return this.key.equals(another.key) && Objects.equals(this.versionId, another.versionId) && Objects.equals(this.deleteMarker, another.deleteMarker) && Objects.equals(this.deleteMarkerVersionId, another.deleteMarkerVersionId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.versionId);
        h += (h << 5) + Objects.hashCode(this.deleteMarker);
        h += (h << 5) + Objects.hashCode(this.deleteMarkerVersionId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeletedS3Object").omitNullValues().add("key", (Object)this.key).add("versionId", (Object)this.versionId).add("deleteMarker", (Object)this.deleteMarker).add("deleteMarkerVersionId", (Object)this.deleteMarkerVersionId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeletedS3Object fromJson(Json json) {
        Builder builder = ImmutableDeletedS3Object.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.versionId != null) {
            builder.versionId(json.versionId);
        }
        if (json.deleteMarker != null) {
            builder.deleteMarker(json.deleteMarker);
        }
        if (json.deleteMarkerVersionId != null) {
            builder.deleteMarkerVersionId(json.deleteMarkerVersionId);
        }
        return builder.build();
    }

    public static ImmutableDeletedS3Object of(String key, @Nullable String versionId) {
        return new ImmutableDeletedS3Object(key, versionId);
    }

    public static ImmutableDeletedS3Object copyOf(DeletedS3Object instance) {
        if (instance instanceof ImmutableDeletedS3Object) {
            return (ImmutableDeletedS3Object)instance;
        }
        return ImmutableDeletedS3Object.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeletedS3Object", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private String key;
        @javax.annotation.Nullable
        private String versionId;
        @javax.annotation.Nullable
        private Boolean deleteMarker;
        @javax.annotation.Nullable
        private String deleteMarkerVersionId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DeletedS3Object instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String versionIdValue;
            ObjectIdentifier instance;
            long bits = 0L;
            if (object instanceof ObjectIdentifier) {
                instance = (ObjectIdentifier)object;
                if ((bits & 1L) == 0L) {
                    versionIdValue = instance.versionId();
                    if (versionIdValue != null) {
                        this.versionId(versionIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
            if (object instanceof DeletedS3Object) {
                String deleteMarkerVersionIdValue;
                Boolean deleteMarkerValue;
                instance = (DeletedS3Object)object;
                if ((bits & 1L) == 0L) {
                    versionIdValue = instance.versionId();
                    if (versionIdValue != null) {
                        this.versionId(versionIdValue);
                    }
                    bits |= 1L;
                }
                if ((deleteMarkerValue = instance.deleteMarker()) != null) {
                    this.deleteMarker(deleteMarkerValue);
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
                if ((deleteMarkerVersionIdValue = instance.deleteMarkerVersionId()) != null) {
                    this.deleteMarkerVersionId(deleteMarkerVersionIdValue);
                }
            }
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="VersionId")
        @CanIgnoreReturnValue
        public final Builder versionId(@Nullable String versionId) {
            this.versionId = versionId;
            return this;
        }

        @JsonProperty(value="DeleteMarker")
        @CanIgnoreReturnValue
        public final Builder deleteMarker(@Nullable Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
            return this;
        }

        @JsonProperty(value="DeleteMarkerVersionId")
        @CanIgnoreReturnValue
        public final Builder deleteMarkerVersionId(@Nullable String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
            return this;
        }

        public ImmutableDeletedS3Object build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeletedS3Object(this.key, this.versionId, this.deleteMarker, this.deleteMarkerVersionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build DeletedS3Object, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeletedS3Object", generator="Immutables")
    static final class Json
    implements DeletedS3Object {
        @javax.annotation.Nullable
        String key;
        @javax.annotation.Nullable
        String versionId;
        @javax.annotation.Nullable
        Boolean deleteMarker;
        @javax.annotation.Nullable
        String deleteMarkerVersionId;

        Json() {
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="VersionId")
        public void setVersionId(@Nullable String versionId) {
            this.versionId = versionId;
        }

        @JsonProperty(value="DeleteMarker")
        public void setDeleteMarker(@Nullable Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        @JsonProperty(value="DeleteMarkerVersionId")
        public void setDeleteMarkerVersionId(@Nullable String deleteMarkerVersionId) {
            this.deleteMarkerVersionId = deleteMarkerVersionId;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String versionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean deleteMarker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String deleteMarkerVersionId() {
            throw new UnsupportedOperationException();
        }
    }
}

