/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.Range;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Range", generator="Immutables")
@Immutable
public final class ImmutableRange
implements Range {
    private final long start;
    private final long end;

    private ImmutableRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    @JsonProperty(value="start")
    public long start() {
        return this.start;
    }

    @Override
    @JsonProperty(value="end")
    public long end() {
        return this.end;
    }

    public final ImmutableRange withStart(long value) {
        if (this.start == value) {
            return this;
        }
        return ImmutableRange.validate(new ImmutableRange(value, this.end));
    }

    public final ImmutableRange withEnd(long value) {
        if (this.end == value) {
            return this;
        }
        return ImmutableRange.validate(new ImmutableRange(this.start, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRange && this.equalTo(0, (ImmutableRange)another);
    }

    private boolean equalTo(int synthetic, ImmutableRange another) {
        return this.start == another.start && this.end == another.end;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.start);
        h += (h << 5) + Longs.hashCode((long)this.end);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Range").omitNullValues().add("start", this.start).add("end", this.end).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRange fromJson(Json json) {
        Builder builder = ImmutableRange.builder();
        if (json.startIsSet) {
            builder.start(json.start);
        }
        if (json.endIsSet) {
            builder.end(json.end);
        }
        return builder.build();
    }

    private static ImmutableRange validate(ImmutableRange instance) {
        instance.check();
        return instance;
    }

    public static ImmutableRange copyOf(Range instance) {
        if (instance instanceof ImmutableRange) {
            return (ImmutableRange)instance;
        }
        return ImmutableRange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Range", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_END = 2L;
        private long initBits = 3L;
        private long start;
        private long end;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Range instance) {
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            this.end(instance.end());
            return this;
        }

        @JsonProperty(value="start")
        @CanIgnoreReturnValue
        public final Builder start(long start) {
            this.start = start;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="end")
        @CanIgnoreReturnValue
        public final Builder end(long end) {
            this.end = end;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRange.validate(new ImmutableRange(this.start, this.end));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("end");
            }
            return "Cannot build Range, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Range", generator="Immutables")
    static final class Json
    implements Range {
        long start;
        boolean startIsSet;
        long end;
        boolean endIsSet;

        Json() {
        }

        @JsonProperty(value="start")
        public void setStart(long start) {
            this.start = start;
            this.startIsSet = true;
        }

        @JsonProperty(value="end")
        public void setEnd(long end) {
            this.end = end;
            this.endIsSet = true;
        }

        @Override
        public long start() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long end() {
            throw new UnsupportedOperationException();
        }
    }
}

