/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.ObjectRetriever;
import org.projectnessie.s3mock.S3Bucket;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3Bucket", generator="Immutables")
@Immutable
public final class ImmutableS3Bucket
extends S3Bucket {
    private final String creationDate;
    private final ObjectRetriever object;
    private final S3Bucket.Deleter deleter;
    private final S3Bucket.Lister lister;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableS3Bucket(Builder builder) {
        if (builder.creationDate != null) {
            this.initShim.creationDate(builder.creationDate);
        }
        if (builder.object != null) {
            this.initShim.object(builder.object);
        }
        if (builder.deleter != null) {
            this.initShim.deleter(builder.deleter);
        }
        if (builder.lister != null) {
            this.initShim.lister(builder.lister);
        }
        this.creationDate = this.initShim.creationDate();
        this.object = this.initShim.object();
        this.deleter = this.initShim.deleter();
        this.lister = this.initShim.lister();
        this.initShim = null;
    }

    private ImmutableS3Bucket(String creationDate, ObjectRetriever object, S3Bucket.Deleter deleter, S3Bucket.Lister lister) {
        this.creationDate = creationDate;
        this.object = object;
        this.deleter = deleter;
        this.lister = lister;
        this.initShim = null;
    }

    @Override
    public String creationDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationDate() : this.creationDate;
    }

    @Override
    public ObjectRetriever object() {
        InitShim shim = this.initShim;
        return shim != null ? shim.object() : this.object;
    }

    @Override
    public S3Bucket.Deleter deleter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleter() : this.deleter;
    }

    @Override
    public S3Bucket.Lister lister() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lister() : this.lister;
    }

    public final ImmutableS3Bucket withCreationDate(String value) {
        String newValue = Objects.requireNonNull(value, "creationDate");
        if (this.creationDate.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Bucket(newValue, this.object, this.deleter, this.lister);
    }

    public final ImmutableS3Bucket withObject(ObjectRetriever value) {
        if (this.object == value) {
            return this;
        }
        ObjectRetriever newValue = Objects.requireNonNull(value, "object");
        return new ImmutableS3Bucket(this.creationDate, newValue, this.deleter, this.lister);
    }

    public final ImmutableS3Bucket withDeleter(S3Bucket.Deleter value) {
        if (this.deleter == value) {
            return this;
        }
        S3Bucket.Deleter newValue = Objects.requireNonNull(value, "deleter");
        return new ImmutableS3Bucket(this.creationDate, this.object, newValue, this.lister);
    }

    public final ImmutableS3Bucket withLister(S3Bucket.Lister value) {
        if (this.lister == value) {
            return this;
        }
        S3Bucket.Lister newValue = Objects.requireNonNull(value, "lister");
        return new ImmutableS3Bucket(this.creationDate, this.object, this.deleter, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3Bucket && this.equalTo(0, (ImmutableS3Bucket)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3Bucket another) {
        return this.creationDate.equals(another.creationDate) && this.object.equals(another.object) && this.deleter.equals(another.deleter) && this.lister.equals(another.lister);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.deleter.hashCode();
        h += (h << 5) + this.lister.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"S3Bucket").omitNullValues().add("creationDate", (Object)this.creationDate).add("object", (Object)this.object).add("deleter", (Object)this.deleter).add("lister", (Object)this.lister).toString();
    }

    public static ImmutableS3Bucket copyOf(S3Bucket instance) {
        if (instance instanceof ImmutableS3Bucket) {
            return (ImmutableS3Bucket)instance;
        }
        return ImmutableS3Bucket.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3Bucket", generator="Immutables")
    private final class InitShim {
        private byte creationDateBuildStage = 0;
        private String creationDate;
        private byte objectBuildStage = 0;
        private ObjectRetriever object;
        private byte deleterBuildStage = 0;
        private S3Bucket.Deleter deleter;
        private byte listerBuildStage = 0;
        private S3Bucket.Lister lister;

        private InitShim() {
        }

        String creationDate() {
            if (this.creationDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationDateBuildStage == 0) {
                this.creationDateBuildStage = (byte)-1;
                this.creationDate = Objects.requireNonNull(ImmutableS3Bucket.super.creationDate(), "creationDate");
                this.creationDateBuildStage = 1;
            }
            return this.creationDate;
        }

        void creationDate(String creationDate) {
            this.creationDate = creationDate;
            this.creationDateBuildStage = 1;
        }

        ObjectRetriever object() {
            if (this.objectBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectBuildStage == 0) {
                this.objectBuildStage = (byte)-1;
                this.object = Objects.requireNonNull(ImmutableS3Bucket.super.object(), "object");
                this.objectBuildStage = 1;
            }
            return this.object;
        }

        void object(ObjectRetriever object) {
            this.object = object;
            this.objectBuildStage = 1;
        }

        S3Bucket.Deleter deleter() {
            if (this.deleterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleterBuildStage == 0) {
                this.deleterBuildStage = (byte)-1;
                this.deleter = Objects.requireNonNull(ImmutableS3Bucket.super.deleter(), "deleter");
                this.deleterBuildStage = 1;
            }
            return this.deleter;
        }

        void deleter(S3Bucket.Deleter deleter) {
            this.deleter = deleter;
            this.deleterBuildStage = 1;
        }

        S3Bucket.Lister lister() {
            if (this.listerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.listerBuildStage == 0) {
                this.listerBuildStage = (byte)-1;
                this.lister = Objects.requireNonNull(ImmutableS3Bucket.super.lister(), "lister");
                this.listerBuildStage = 1;
            }
            return this.lister;
        }

        void lister(S3Bucket.Lister lister) {
            this.lister = lister;
            this.listerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.creationDateBuildStage == -1) {
                attributes.add("creationDate");
            }
            if (this.objectBuildStage == -1) {
                attributes.add("object");
            }
            if (this.deleterBuildStage == -1) {
                attributes.add("deleter");
            }
            if (this.listerBuildStage == -1) {
                attributes.add("lister");
            }
            return "Cannot build S3Bucket, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="S3Bucket", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String creationDate;
        @Nullable
        private ObjectRetriever object;
        @Nullable
        private S3Bucket.Deleter deleter;
        @Nullable
        private S3Bucket.Lister lister;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3Bucket instance) {
            Objects.requireNonNull(instance, "instance");
            this.creationDate(instance.creationDate());
            this.object(instance.object());
            this.deleter(instance.deleter());
            this.lister(instance.lister());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creationDate(String creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(ObjectRetriever object) {
            this.object = Objects.requireNonNull(object, "object");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleter(S3Bucket.Deleter deleter) {
            this.deleter = Objects.requireNonNull(deleter, "deleter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lister(S3Bucket.Lister lister) {
            this.lister = Objects.requireNonNull(lister, "lister");
            return this;
        }

        public ImmutableS3Bucket build() {
            return new ImmutableS3Bucket(this);
        }
    }
}

