/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.ListBucketResult;
import org.projectnessie.s3mock.data.ListBucketResultBase;
import org.projectnessie.s3mock.data.Prefix;
import org.projectnessie.s3mock.data.S3Object;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ListBucketResult", generator="Immutables")
@Immutable
public final class ImmutableListBucketResult
implements ListBucketResult {
    private final String name;
    @Nullable
    private final String prefix;
    private final int maxKeys;
    @Nullable
    private final String encodingType;
    private final boolean isTruncated;
    private final List<S3Object> contents;
    private final List<Prefix> commonPrefixes;
    @Nullable
    private final String marker;
    @Nullable
    private final String nextMarker;

    private ImmutableListBucketResult(String name, @Nullable String prefix, int maxKeys, @Nullable String encodingType, boolean isTruncated, List<S3Object> contents, List<Prefix> commonPrefixes, @Nullable String marker, @Nullable String nextMarker) {
        this.name = name;
        this.prefix = prefix;
        this.maxKeys = maxKeys;
        this.encodingType = encodingType;
        this.isTruncated = isTruncated;
        this.contents = contents;
        this.commonPrefixes = commonPrefixes;
        this.marker = marker;
        this.nextMarker = nextMarker;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Prefix")
    @Nullable
    public String prefix() {
        return this.prefix;
    }

    @Override
    @JsonProperty(value="MaxKeys")
    public int maxKeys() {
        return this.maxKeys;
    }

    @Override
    @JsonProperty(value="EncodingType")
    @Nullable
    public String encodingType() {
        return this.encodingType;
    }

    @Override
    @JsonProperty(value="IsTruncated")
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    @JsonProperty(value="Contents")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<S3Object> contents() {
        return this.contents;
    }

    @Override
    @JsonProperty(value="CommonPrefixes")
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Prefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    @Override
    @JsonProperty(value="Marker")
    @Nullable
    public String marker() {
        return this.marker;
    }

    @Override
    @JsonProperty(value="NextMarker")
    @Nullable
    public String nextMarker() {
        return this.nextMarker;
    }

    public final ImmutableListBucketResult withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableListBucketResult(newValue, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withPrefix(@Nullable String value) {
        if (Objects.equals(this.prefix, value)) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, value, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withMaxKeys(int value) {
        if (this.maxKeys == value) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, this.prefix, value, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withEncodingType(@Nullable String value) {
        if (Objects.equals(this.encodingType, value)) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, value, this.isTruncated, this.contents, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withIsTruncated(boolean value) {
        if (this.isTruncated == value) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, value, this.contents, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withContents(S3Object ... elements) {
        List<S3Object> newValue = ImmutableListBucketResult.createUnmodifiableList(false, ImmutableListBucketResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, newValue, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withContents(Iterable<? extends S3Object> elements) {
        if (this.contents == elements) {
            return this;
        }
        List<S3Object> newValue = ImmutableListBucketResult.createUnmodifiableList(false, ImmutableListBucketResult.createSafeList(elements, true, false));
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, newValue, this.commonPrefixes, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withCommonPrefixes(Prefix ... elements) {
        List<Prefix> newValue = ImmutableListBucketResult.createUnmodifiableList(false, ImmutableListBucketResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, newValue, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withCommonPrefixes(Iterable<? extends Prefix> elements) {
        if (this.commonPrefixes == elements) {
            return this;
        }
        List<Prefix> newValue = ImmutableListBucketResult.createUnmodifiableList(false, ImmutableListBucketResult.createSafeList(elements, true, false));
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, newValue, this.marker, this.nextMarker);
    }

    public final ImmutableListBucketResult withMarker(@Nullable String value) {
        if (Objects.equals(this.marker, value)) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, value, this.nextMarker);
    }

    public final ImmutableListBucketResult withNextMarker(@Nullable String value) {
        if (Objects.equals(this.nextMarker, value)) {
            return this;
        }
        return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, this.contents, this.commonPrefixes, this.marker, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListBucketResult && this.equalTo(0, (ImmutableListBucketResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableListBucketResult another) {
        return this.name.equals(another.name) && Objects.equals(this.prefix, another.prefix) && this.maxKeys == another.maxKeys && Objects.equals(this.encodingType, another.encodingType) && this.isTruncated == another.isTruncated && this.contents.equals(another.contents) && this.commonPrefixes.equals(another.commonPrefixes) && Objects.equals(this.marker, another.marker) && Objects.equals(this.nextMarker, another.nextMarker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.prefix);
        h += (h << 5) + this.maxKeys;
        h += (h << 5) + Objects.hashCode(this.encodingType);
        h += (h << 5) + Boolean.hashCode(this.isTruncated);
        h += (h << 5) + this.contents.hashCode();
        h += (h << 5) + this.commonPrefixes.hashCode();
        h += (h << 5) + Objects.hashCode(this.marker);
        h += (h << 5) + Objects.hashCode(this.nextMarker);
        return h;
    }

    public String toString() {
        return "ListBucketResult{name=" + this.name + ", prefix=" + this.prefix + ", maxKeys=" + this.maxKeys + ", encodingType=" + this.encodingType + ", isTruncated=" + this.isTruncated + ", contents=" + this.contents + ", commonPrefixes=" + this.commonPrefixes + ", marker=" + this.marker + ", nextMarker=" + this.nextMarker + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListBucketResult fromJson(Json json) {
        Builder builder = ImmutableListBucketResult.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.prefix != null) {
            builder.prefix(json.prefix);
        }
        if (json.maxKeysIsSet) {
            builder.maxKeys(json.maxKeys);
        }
        if (json.encodingType != null) {
            builder.encodingType(json.encodingType);
        }
        if (json.isTruncatedIsSet) {
            builder.isTruncated(json.isTruncated);
        }
        if (json.contents != null) {
            builder.addAllContents(json.contents);
        }
        if (json.commonPrefixes != null) {
            builder.addAllCommonPrefixes(json.commonPrefixes);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        if (json.nextMarker != null) {
            builder.nextMarker(json.nextMarker);
        }
        return builder.build();
    }

    public static ImmutableListBucketResult copyOf(ListBucketResult instance) {
        if (instance instanceof ImmutableListBucketResult) {
            return (ImmutableListBucketResult)instance;
        }
        return ImmutableListBucketResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListBucketResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ListBucketResult.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_MAX_KEYS = 2L;
        private static final long INIT_BIT_IS_TRUNCATED = 4L;
        private long initBits = 7L;
        @javax.annotation.Nullable
        private String name;
        @javax.annotation.Nullable
        private String prefix;
        private int maxKeys;
        @javax.annotation.Nullable
        private String encodingType;
        private boolean isTruncated;
        private List<S3Object> contents = new ArrayList<S3Object>();
        private List<Prefix> commonPrefixes = new ArrayList<Prefix>();
        @javax.annotation.Nullable
        private String marker;
        @javax.annotation.Nullable
        private String nextMarker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ListBucketResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ListBucketResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ListBucketResultBase instance;
            long bits = 0L;
            if (object instanceof ListBucketResultBase) {
                instance = (ListBucketResultBase)object;
                if ((bits & 1L) == 0L) {
                    this.isTruncated(instance.isTruncated());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.maxKeys(instance.maxKeys());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllContents(instance.contents());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String prefixValue = instance.prefix();
                    if (prefixValue != null) {
                        this.prefix(prefixValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    String encodingTypeValue = instance.encodingType();
                    if (encodingTypeValue != null) {
                        this.encodingType(encodingTypeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllCommonPrefixes(instance.commonPrefixes());
                    bits |= 0x40L;
                }
            }
            if (object instanceof ListBucketResult) {
                String markerValue;
                String nextMarkerValue;
                instance = (ListBucketResult)object;
                if ((bits & 1L) == 0L) {
                    this.isTruncated(instance.isTruncated());
                    bits |= 1L;
                }
                if ((nextMarkerValue = instance.nextMarker()) != null) {
                    this.nextMarker(nextMarkerValue);
                }
                if ((bits & 2L) == 0L) {
                    this.maxKeys(instance.maxKeys());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllContents(instance.contents());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String prefixValue = instance.prefix();
                    if (prefixValue != null) {
                        this.prefix(prefixValue);
                    }
                    bits |= 8L;
                }
                if ((markerValue = instance.marker()) != null) {
                    this.marker(markerValue);
                }
                if ((bits & 0x10L) == 0L) {
                    String encodingTypeValue = instance.encodingType();
                    if (encodingTypeValue != null) {
                        this.encodingType(encodingTypeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllCommonPrefixes(instance.commonPrefixes());
                    bits |= 0x40L;
                }
            }
        }

        @Override
        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Prefix")
        @CanIgnoreReturnValue
        public final Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        @JsonProperty(value="MaxKeys")
        @CanIgnoreReturnValue
        public final Builder maxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="EncodingType")
        @CanIgnoreReturnValue
        public final Builder encodingType(@Nullable String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        @JsonProperty(value="IsTruncated")
        @CanIgnoreReturnValue
        public final Builder isTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addContents(S3Object element) {
            this.contents.add(Objects.requireNonNull(element, "contents element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addContents(S3Object ... elements) {
            for (S3Object element : elements) {
                this.contents.add(Objects.requireNonNull(element, "contents element"));
            }
            return this;
        }

        @JsonProperty(value="Contents")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder contents(Iterable<? extends S3Object> elements) {
            this.contents.clear();
            return this.addAllContents((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllContents(Iterable<? extends S3Object> elements) {
            for (S3Object s3Object : elements) {
                this.contents.add(Objects.requireNonNull(s3Object, "contents element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCommonPrefixes(Prefix element) {
            this.commonPrefixes.add(Objects.requireNonNull(element, "commonPrefixes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCommonPrefixes(Prefix ... elements) {
            for (Prefix element : elements) {
                this.commonPrefixes.add(Objects.requireNonNull(element, "commonPrefixes element"));
            }
            return this;
        }

        @JsonProperty(value="CommonPrefixes")
        @JacksonXmlElementWrapper(useWrapping=false)
        @CanIgnoreReturnValue
        public final Builder commonPrefixes(Iterable<? extends Prefix> elements) {
            this.commonPrefixes.clear();
            return this.addAllCommonPrefixes((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllCommonPrefixes(Iterable<? extends Prefix> elements) {
            for (Prefix prefix : elements) {
                this.commonPrefixes.add(Objects.requireNonNull(prefix, "commonPrefixes element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Marker")
        @CanIgnoreReturnValue
        public final Builder marker(@Nullable String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        @JsonProperty(value="NextMarker")
        @CanIgnoreReturnValue
        public final Builder nextMarker(@Nullable String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ImmutableListBucketResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableListBucketResult(this.name, this.prefix, this.maxKeys, this.encodingType, this.isTruncated, ImmutableListBucketResult.createUnmodifiableList(true, this.contents), ImmutableListBucketResult.createUnmodifiableList(true, this.commonPrefixes), this.marker, this.nextMarker);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxKeys");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isTruncated");
            }
            return "Cannot build ListBucketResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListBucketResult", generator="Immutables")
    static final class Json
    implements ListBucketResult {
        @javax.annotation.Nullable
        String name;
        @javax.annotation.Nullable
        String prefix;
        int maxKeys;
        boolean maxKeysIsSet;
        @javax.annotation.Nullable
        String encodingType;
        boolean isTruncated;
        boolean isTruncatedIsSet;
        @javax.annotation.Nullable
        List<S3Object> contents = Collections.emptyList();
        @javax.annotation.Nullable
        List<Prefix> commonPrefixes = Collections.emptyList();
        @javax.annotation.Nullable
        String marker;
        @javax.annotation.Nullable
        String nextMarker;

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Prefix")
        public void setPrefix(@Nullable String prefix) {
            this.prefix = prefix;
        }

        @JsonProperty(value="MaxKeys")
        public void setMaxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            this.maxKeysIsSet = true;
        }

        @JsonProperty(value="EncodingType")
        public void setEncodingType(@Nullable String encodingType) {
            this.encodingType = encodingType;
        }

        @JsonProperty(value="IsTruncated")
        public void setIsTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            this.isTruncatedIsSet = true;
        }

        @JsonProperty(value="Contents")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setContents(List<S3Object> contents) {
            this.contents = contents;
        }

        @JsonProperty(value="CommonPrefixes")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setCommonPrefixes(List<Prefix> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @JsonProperty(value="Marker")
        public void setMarker(@Nullable String marker) {
            this.marker = marker;
        }

        @JsonProperty(value="NextMarker")
        public void setNextMarker(@Nullable String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String prefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int maxKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encodingType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTruncated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<S3Object> contents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Prefix> commonPrefixes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String marker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextMarker() {
            throw new UnsupportedOperationException();
        }
    }
}

