/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.tasks.async.vertx;

import io.vertx.core.Vertx;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.projectnessie.nessie.tasks.async.TasksAsync;

public class VertxTasksAsync
implements TasksAsync {
    private final Vertx vertx;
    private final Clock clock;
    private final long minimumDelayMillis;

    public VertxTasksAsync(Vertx vertx, Clock clock, long minimumDelayMillis) {
        this.vertx = vertx;
        this.clock = clock;
        this.minimumDelayMillis = minimumDelayMillis;
    }

    @Override
    public <R> CompletionStage<R> supply(Supplier<R> supplier) {
        return this.vertx.executeBlocking(() -> {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, false).toCompletionStage();
    }

    @Override
    public CompletionStage<Void> schedule(Runnable runnable, Instant scheduleNotBefore) {
        long realDelay = this.calculateDelay(this.clock, this.minimumDelayMillis, scheduleNotBefore);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        long timerId = this.vertx.setTimer(realDelay, id -> this.vertx.executeBlocking(() -> {
            try {
                runnable.run();
                completableFuture.complete(null);
                return null;
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(new CompletionException(t));
                return null;
            }
        }));
        completableFuture.whenComplete((v, t) -> {
            if (t instanceof CancellationException) {
                this.vertx.cancelTimer(timerId);
            }
        });
        return completableFuture;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }
}

