/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.tasks.async.pool;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.projectnessie.nessie.tasks.async.TasksAsync;

public class JavaPoolTasksAsync
implements TasksAsync {
    private final ScheduledExecutorService executorService;
    private final Clock clock;
    private final long minimumDelayMillis;

    public JavaPoolTasksAsync(ScheduledExecutorService executorService, Clock clock, long minimumDelayMillis) {
        this.executorService = executorService;
        this.clock = clock;
        this.minimumDelayMillis = minimumDelayMillis;
    }

    @Override
    public <R> CompletionStage<R> supply(Supplier<R> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.executorService);
    }

    @Override
    public CompletionStage<Void> schedule(Runnable runnable, Instant scheduleNotBefore) {
        long realDelay = this.calculateDelay(this.clock, this.minimumDelayMillis, scheduleNotBefore);
        CompletableFuture<Void> completable = new CompletableFuture<Void>();
        ScheduledFuture<?> future = this.executorService.schedule(() -> {
            try {
                runnable.run();
                completable.complete(null);
            }
            catch (Throwable t) {
                completable.completeExceptionally(new CompletionException(t));
            }
        }, realDelay, TimeUnit.MILLISECONDS);
        completable.whenComplete((v, t) -> {
            if (t instanceof CancellationException) {
                future.cancel(true);
            }
        });
        return completable;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }
}

