/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.events;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.OperationType;
import org.projectnessie.versioned.persist.adapter.events.ReferenceDeletedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceEvent;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferenceDeletedEvent", generator="Immutables")
@Immutable
public final class ImmutableReferenceDeletedEvent
implements ReferenceDeletedEvent {
    private final long eventTimeMicros;
    private final NamedRef ref;
    private final Hash currentHash;
    private final OperationType operationType;

    private ImmutableReferenceDeletedEvent(Builder builder) {
        this.eventTimeMicros = builder.eventTimeMicros;
        this.ref = builder.ref;
        this.currentHash = builder.currentHash;
        this.operationType = builder.operationType != null ? builder.operationType : Objects.requireNonNull(ReferenceDeletedEvent.super.getOperationType(), "operationType");
    }

    private ImmutableReferenceDeletedEvent(long eventTimeMicros, NamedRef ref, Hash currentHash, OperationType operationType) {
        this.eventTimeMicros = eventTimeMicros;
        this.ref = ref;
        this.currentHash = currentHash;
        this.operationType = operationType;
    }

    @Override
    public long getEventTimeMicros() {
        return this.eventTimeMicros;
    }

    @Override
    public NamedRef getRef() {
        return this.ref;
    }

    @Override
    public Hash getCurrentHash() {
        return this.currentHash;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public final ImmutableReferenceDeletedEvent withEventTimeMicros(long value) {
        if (this.eventTimeMicros == value) {
            return this;
        }
        return new ImmutableReferenceDeletedEvent(value, this.ref, this.currentHash, this.operationType);
    }

    public final ImmutableReferenceDeletedEvent withRef(NamedRef value) {
        if (this.ref == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "ref");
        return new ImmutableReferenceDeletedEvent(this.eventTimeMicros, newValue, this.currentHash, this.operationType);
    }

    public final ImmutableReferenceDeletedEvent withCurrentHash(Hash value) {
        if (this.currentHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "currentHash");
        return new ImmutableReferenceDeletedEvent(this.eventTimeMicros, this.ref, newValue, this.operationType);
    }

    public final ImmutableReferenceDeletedEvent withOperationType(OperationType value) {
        OperationType newValue = Objects.requireNonNull(value, "operationType");
        if (this.operationType == newValue) {
            return this;
        }
        return new ImmutableReferenceDeletedEvent(this.eventTimeMicros, this.ref, this.currentHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceDeletedEvent && this.equalTo(0, (ImmutableReferenceDeletedEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferenceDeletedEvent another) {
        return this.eventTimeMicros == another.eventTimeMicros && this.ref.equals(another.ref) && this.currentHash.equals(another.currentHash) && this.operationType.equals((Object)another.operationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.eventTimeMicros);
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + this.currentHash.hashCode();
        h += (h << 5) + this.operationType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceDeletedEvent").omitNullValues().add("eventTimeMicros", this.eventTimeMicros).add("ref", (Object)this.ref).add("currentHash", (Object)this.currentHash).add("operationType", (Object)this.operationType).toString();
    }

    public static ImmutableReferenceDeletedEvent copyOf(ReferenceDeletedEvent instance) {
        if (instance instanceof ImmutableReferenceDeletedEvent) {
            return (ImmutableReferenceDeletedEvent)instance;
        }
        return ImmutableReferenceDeletedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceDeletedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ReferenceDeletedEvent.Builder {
        private static final long INIT_BIT_EVENT_TIME_MICROS = 1L;
        private static final long INIT_BIT_REF = 2L;
        private static final long INIT_BIT_CURRENT_HASH = 4L;
        private long initBits = 7L;
        private long eventTimeMicros;
        @Nullable
        private NamedRef ref;
        @Nullable
        private Hash currentHash;
        @Nullable
        private OperationType operationType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceDeletedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdapterEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AdapterEvent instance;
            long bits = 0L;
            if (object instanceof ReferenceDeletedEvent) {
                instance = (ReferenceDeletedEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.currentHash(instance.getCurrentHash());
                    bits |= 2L;
                }
            }
            if (object instanceof ReferenceEvent) {
                instance = (ReferenceEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.currentHash(instance.getCurrentHash());
                    bits |= 2L;
                }
            }
            if (object instanceof AdapterEvent) {
                instance = (AdapterEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 8L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder eventTimeMicros(long eventTimeMicros) {
            this.eventTimeMicros = eventTimeMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder ref(NamedRef ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder currentHash(Hash currentHash) {
            this.currentHash = Objects.requireNonNull(currentHash, "currentHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder operationType(OperationType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
            return this;
        }

        @Override
        public ImmutableReferenceDeletedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceDeletedEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventTimeMicros");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ref");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currentHash");
            }
            return "Cannot build ReferenceDeletedEvent, some of required attributes are not set " + attributes;
        }
    }
}

