/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.events;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.OperationType;
import org.projectnessie.versioned.persist.adapter.events.RepositoryInitializedEvent;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryInitializedEvent", generator="Immutables")
@Immutable
public final class ImmutableRepositoryInitializedEvent
implements RepositoryInitializedEvent {
    private final long eventTimeMicros;
    private final String defaultBranch;
    private final OperationType operationType;

    private ImmutableRepositoryInitializedEvent(Builder builder) {
        this.eventTimeMicros = builder.eventTimeMicros;
        this.defaultBranch = builder.defaultBranch;
        this.operationType = builder.operationType != null ? builder.operationType : Objects.requireNonNull(RepositoryInitializedEvent.super.getOperationType(), "operationType");
    }

    private ImmutableRepositoryInitializedEvent(long eventTimeMicros, String defaultBranch, OperationType operationType) {
        this.eventTimeMicros = eventTimeMicros;
        this.defaultBranch = defaultBranch;
        this.operationType = operationType;
    }

    @Override
    public long getEventTimeMicros() {
        return this.eventTimeMicros;
    }

    @Override
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public final ImmutableRepositoryInitializedEvent withEventTimeMicros(long value) {
        if (this.eventTimeMicros == value) {
            return this;
        }
        return new ImmutableRepositoryInitializedEvent(value, this.defaultBranch, this.operationType);
    }

    public final ImmutableRepositoryInitializedEvent withDefaultBranch(String value) {
        String newValue = Objects.requireNonNull(value, "defaultBranch");
        if (this.defaultBranch.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryInitializedEvent(this.eventTimeMicros, newValue, this.operationType);
    }

    public final ImmutableRepositoryInitializedEvent withOperationType(OperationType value) {
        OperationType newValue = Objects.requireNonNull(value, "operationType");
        if (this.operationType == newValue) {
            return this;
        }
        return new ImmutableRepositoryInitializedEvent(this.eventTimeMicros, this.defaultBranch, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryInitializedEvent && this.equalTo(0, (ImmutableRepositoryInitializedEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryInitializedEvent another) {
        return this.eventTimeMicros == another.eventTimeMicros && this.defaultBranch.equals(another.defaultBranch) && this.operationType.equals((Object)another.operationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.eventTimeMicros);
        h += (h << 5) + this.defaultBranch.hashCode();
        h += (h << 5) + this.operationType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepositoryInitializedEvent").omitNullValues().add("eventTimeMicros", this.eventTimeMicros).add("defaultBranch", (Object)this.defaultBranch).add("operationType", (Object)this.operationType).toString();
    }

    public static ImmutableRepositoryInitializedEvent copyOf(RepositoryInitializedEvent instance) {
        if (instance instanceof ImmutableRepositoryInitializedEvent) {
            return (ImmutableRepositoryInitializedEvent)instance;
        }
        return ImmutableRepositoryInitializedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryInitializedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RepositoryInitializedEvent.Builder {
        private static final long INIT_BIT_EVENT_TIME_MICROS = 1L;
        private static final long INIT_BIT_DEFAULT_BRANCH = 2L;
        private long initBits = 3L;
        private long eventTimeMicros;
        @Nullable
        private String defaultBranch;
        @Nullable
        private OperationType operationType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryInitializedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdapterEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AdapterEvent instance;
            long bits = 0L;
            if (object instanceof RepositoryInitializedEvent) {
                instance = (RepositoryInitializedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 2L;
                }
                this.defaultBranch(instance.getDefaultBranch());
            }
            if (object instanceof AdapterEvent) {
                instance = (AdapterEvent)object;
                if ((bits & 1L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 2L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder eventTimeMicros(long eventTimeMicros) {
            this.eventTimeMicros = eventTimeMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = Objects.requireNonNull(defaultBranch, "defaultBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder operationType(OperationType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
            return this;
        }

        @Override
        public ImmutableRepositoryInitializedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryInitializedEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventTimeMicros");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultBranch");
            }
            return "Cannot build RepositoryInitializedEvent, some of required attributes are not set " + attributes;
        }
    }
}

