/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.annotations.Beta;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.agrona.collections.Object2IntHashMap;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ReferencedAndUnreferencedHeads;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;

@Beta
public final class ReferencesUtil {
    private final DatabaseAdapter databaseAdapter;

    private ReferencesUtil(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    public static ReferencesUtil forDatabaseAdapter(DatabaseAdapter databaseAdapter) {
        return new ReferencesUtil(databaseAdapter);
    }

    private static <K, V> Map<K, V> newOpenAddressingHashMap() {
        return new Object2ObjectHashMap(16, 0.65f, false);
    }

    private static <T> Set<T> newOpenAddressingHashSet() {
        return new ObjectHashSet(8, 0.65f, false);
    }

    private static <T> Set<T> newOpenAddressingHashSet(Set<T> source) {
        ObjectHashSet copy = new ObjectHashSet(source.size(), 0.65f, false);
        if (source instanceof ObjectHashSet) {
            copy.addAll((ObjectHashSet)source);
        } else {
            copy.addAll(source);
        }
        return copy;
    }

    public HeadsAndForkPoints identifyAllHeadsAndForkPoints(int expectedCommitCount, Consumer<CommitLogEntry> commitHandler) {
        long scanStartedAtInMicros = this.databaseAdapter.getConfig().currentTimeInMicros();
        IdentifyHeadsAndForkPoints identify = new IdentifyHeadsAndForkPoints(expectedCommitCount, scanStartedAtInMicros);
        try (Stream<CommitLogEntry> scan = this.databaseAdapter.scanAllCommitLogEntries();){
            scan.peek(commitHandler).forEach(identify::handleCommit);
        }
        return identify.finish();
    }

    public ReferencedAndUnreferencedHeads identifyReferencedAndUnreferencedHeads(HeadsAndForkPoints headsAndForkPoints) throws ReferenceNotFoundException {
        Map<Hash, Set<NamedRef>> referenced = ReferencesUtil.newOpenAddressingHashMap();
        Set<Hash> heads = headsAndForkPoints.getHeads();
        Set<Hash> unreferenced = ReferencesUtil.newOpenAddressingHashSet(heads);
        long stopAtCommitTimeMicros = headsAndForkPoints.getScanStartedAtInMicros() - this.databaseAdapter.getConfig().getAssumedWallClockDriftMicros();
        try (Stream<ReferenceInfo<ByteString>> namedRefs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            namedRefs.forEach(refInfo -> {
                try (Stream<CommitLogEntry> logs = this.databaseAdapter.commitLog(refInfo.getHash());){
                    if (!referenced.containsKey(refInfo.getHash())) {
                        CommitLogEntry entry;
                        Hash commitId;
                        Iterator logIter = logs.iterator();
                        while (logIter.hasNext() && !referenced.containsKey(commitId = (entry = (CommitLogEntry)logIter.next()).getHash())) {
                            if (heads.contains(commitId)) {
                                unreferenced.remove(entry.getHash());
                            }
                            if (entry.getCreatedTime() >= stopAtCommitTimeMicros) continue;
                            break;
                        }
                    }
                    referenced.computeIfAbsent(refInfo.getHash(), x -> ReferencesUtil.newOpenAddressingHashSet()).add(refInfo.getNamedRef());
                }
                catch (ReferenceNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return ReferencedAndUnreferencedHeads.of(referenced, unreferenced);
    }

    public static class IdentifyHeadsAndForkPoints {
        private final Object2IntHashMap<Hash> commits;
        private final Set<Hash> heads;
        private final Set<Hash> forkPoints;
        private final long scanStartedAtInMicros;
        private static final int MASK_COMMIT_SEEN = 1;
        private static final int MASK_PARENT_SEEN = 2;

        public IdentifyHeadsAndForkPoints(int expectedCommitCount, long scanStartedAtInMicros) {
            this.commits = new Object2IntHashMap(expectedCommitCount * 2, 0.65f, 0, true);
            this.heads = ReferencesUtil.newOpenAddressingHashSet();
            this.forkPoints = ReferencesUtil.newOpenAddressingHashSet();
            this.scanStartedAtInMicros = scanStartedAtInMicros;
        }

        public boolean handleCommit(CommitLogEntry entry) {
            return this.handleCommit(entry.getHash(), entry.getParents().get(0));
        }

        public boolean handleCommit(Hash commitId, Hash parent) {
            boolean parentNew;
            boolean commitNotSeenAsParent;
            boolean commitNew;
            int cv = this.commits.getValue((Object)commitId);
            boolean bl = commitNew = (cv & 1) == 0;
            if (commitNew) {
                this.commits.put((Object)commitId, cv | 1);
            }
            boolean bl2 = commitNotSeenAsParent = (cv & 2) == 0;
            if (commitNotSeenAsParent) {
                this.heads.add(commitId);
            }
            if (!commitNew) {
                return false;
            }
            if (AbstractDatabaseAdapter.NO_ANCESTOR.equals(parent)) {
                return true;
            }
            int pv = this.commits.getValue((Object)parent);
            boolean bl3 = parentNew = (pv & 2) == 0;
            if (!parentNew) {
                this.forkPoints.add(parent);
            } else {
                this.commits.put((Object)parent, pv | 2);
                this.heads.remove(parent);
            }
            return true;
        }

        public HeadsAndForkPoints finish() {
            return HeadsAndForkPoints.of(this.heads, this.forkPoints, this.scanStartedAtInMicros);
        }
    }
}

