/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;

public interface DatabaseAdapter {
    public DatabaseAdapterConfig getConfig();

    public void initializeRepo(String var1);

    public void eraseRepo();

    public Hash noAncestorHash();

    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException;

    public Map<ContentKey, ContentAndState> values(Hash var1, Collection<ContentKey> var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<CommitLogEntry> commitLog(Hash var1) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<CommitLogEntry> fetchCommitLogEntries(Stream<Hash> var1);

    @MustBeClosed
    public Stream<KeyListEntry> keys(Hash var1, KeyFilterPredicate var2) throws ReferenceNotFoundException;

    public Hash commit(CommitParams var1) throws ReferenceConflictException, ReferenceNotFoundException;

    public MergeResult<CommitLogEntry> transplant(TransplantParams var1) throws ReferenceNotFoundException, ReferenceConflictException;

    public MergeResult<CommitLogEntry> merge(MergeParams var1) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceInfo<ByteString> namedRef(String var1, GetNamedRefsParams var2) throws ReferenceNotFoundException;

    @MustBeClosed
    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams var1) throws ReferenceNotFoundException;

    public Hash create(NamedRef var1, Hash var2) throws ReferenceAlreadyExistsException, ReferenceNotFoundException;

    public Hash delete(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public void assign(NamedRef var1, Optional<Hash> var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    @MustBeClosed
    public Stream<Difference> diff(Hash var1, Hash var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    public RepoDescription fetchRepositoryDescription();

    public void updateRepositoryDescription(Function<RepoDescription, RepoDescription> var1) throws ReferenceConflictException;

    public Optional<ContentIdAndBytes> globalContent(ContentId var1);

    public Map<String, Map<String, String>> repoMaintenance(RepoMaintenanceParams var1);

    @MustBeClosed
    public Stream<RefLog> refLog(Hash var1) throws RefLogNotFoundException;

    @MustBeClosed
    public Stream<CommitLogEntry> scanAllCommitLogEntries();

    @VisibleForTesting
    public void assertCleanStateForTests();

    public void writeMultipleCommits(List<CommitLogEntry> var1) throws ReferenceConflictException;

    public void updateMultipleCommits(List<CommitLogEntry> var1) throws ReferenceNotFoundException;

    public CommitLogEntry rebuildKeyList(CommitLogEntry var1, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> var2) throws ReferenceNotFoundException;
}

