/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HeadsAndForkPoints", generator="Immutables")
@Immutable
public final class ImmutableHeadsAndForkPoints
implements HeadsAndForkPoints {
    private final ImmutableSet<Hash> heads;
    private final ImmutableSet<Hash> forkPoints;
    private final long scanStartedAtInMicros;

    private ImmutableHeadsAndForkPoints(Iterable<? extends Hash> heads, Iterable<? extends Hash> forkPoints, long scanStartedAtInMicros) {
        this.heads = ImmutableSet.copyOf(heads);
        this.forkPoints = ImmutableSet.copyOf(forkPoints);
        this.scanStartedAtInMicros = scanStartedAtInMicros;
    }

    private ImmutableHeadsAndForkPoints(ImmutableHeadsAndForkPoints original, ImmutableSet<Hash> heads, ImmutableSet<Hash> forkPoints, long scanStartedAtInMicros) {
        this.heads = heads;
        this.forkPoints = forkPoints;
        this.scanStartedAtInMicros = scanStartedAtInMicros;
    }

    public ImmutableSet<Hash> getHeads() {
        return this.heads;
    }

    public ImmutableSet<Hash> getForkPoints() {
        return this.forkPoints;
    }

    @Override
    public long getScanStartedAtInMicros() {
        return this.scanStartedAtInMicros;
    }

    public final ImmutableHeadsAndForkPoints withHeads(Hash ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableHeadsAndForkPoints(this, (ImmutableSet<Hash>)newValue, this.forkPoints, this.scanStartedAtInMicros);
    }

    public final ImmutableHeadsAndForkPoints withHeads(Iterable<? extends Hash> elements) {
        if (this.heads == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableHeadsAndForkPoints(this, (ImmutableSet<Hash>)newValue, this.forkPoints, this.scanStartedAtInMicros);
    }

    public final ImmutableHeadsAndForkPoints withForkPoints(Hash ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableHeadsAndForkPoints(this, this.heads, (ImmutableSet<Hash>)newValue, this.scanStartedAtInMicros);
    }

    public final ImmutableHeadsAndForkPoints withForkPoints(Iterable<? extends Hash> elements) {
        if (this.forkPoints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableHeadsAndForkPoints(this, this.heads, (ImmutableSet<Hash>)newValue, this.scanStartedAtInMicros);
    }

    public final ImmutableHeadsAndForkPoints withScanStartedAtInMicros(long value) {
        if (this.scanStartedAtInMicros == value) {
            return this;
        }
        return new ImmutableHeadsAndForkPoints(this, this.heads, this.forkPoints, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHeadsAndForkPoints && this.equalTo(0, (ImmutableHeadsAndForkPoints)another);
    }

    private boolean equalTo(int synthetic, ImmutableHeadsAndForkPoints another) {
        return this.heads.equals(another.heads) && this.forkPoints.equals(another.forkPoints) && this.scanStartedAtInMicros == another.scanStartedAtInMicros;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.heads.hashCode();
        h += (h << 5) + this.forkPoints.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.scanStartedAtInMicros);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HeadsAndForkPoints").omitNullValues().add("heads", this.heads).add("forkPoints", this.forkPoints).add("scanStartedAtInMicros", this.scanStartedAtInMicros).toString();
    }

    public static ImmutableHeadsAndForkPoints of(Set<Hash> heads, Set<Hash> forkPoints, long scanStartedAtInMicros) {
        return ImmutableHeadsAndForkPoints.of(heads, forkPoints, scanStartedAtInMicros);
    }

    public static ImmutableHeadsAndForkPoints of(Iterable<? extends Hash> heads, Iterable<? extends Hash> forkPoints, long scanStartedAtInMicros) {
        return new ImmutableHeadsAndForkPoints(heads, forkPoints, scanStartedAtInMicros);
    }

    public static ImmutableHeadsAndForkPoints copyOf(HeadsAndForkPoints instance) {
        if (instance instanceof ImmutableHeadsAndForkPoints) {
            return (ImmutableHeadsAndForkPoints)instance;
        }
        return ImmutableHeadsAndForkPoints.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HeadsAndForkPoints", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCAN_STARTED_AT_IN_MICROS = 1L;
        private long initBits = 1L;
        private ImmutableSet.Builder<Hash> heads = ImmutableSet.builder();
        private ImmutableSet.Builder<Hash> forkPoints = ImmutableSet.builder();
        private long scanStartedAtInMicros;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HeadsAndForkPoints instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllHeads(instance.getHeads());
            this.addAllForkPoints(instance.getForkPoints());
            this.scanStartedAtInMicros(instance.getScanStartedAtInMicros());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeads(Hash element) {
            this.heads.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeads(Hash ... elements) {
            this.heads.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder heads(Iterable<? extends Hash> elements) {
            this.heads = ImmutableSet.builder();
            return this.addAllHeads(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHeads(Iterable<? extends Hash> elements) {
            this.heads.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addForkPoints(Hash element) {
            this.forkPoints.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addForkPoints(Hash ... elements) {
            this.forkPoints.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder forkPoints(Iterable<? extends Hash> elements) {
            this.forkPoints = ImmutableSet.builder();
            return this.addAllForkPoints(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllForkPoints(Iterable<? extends Hash> elements) {
            this.forkPoints.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scanStartedAtInMicros(long scanStartedAtInMicros) {
            this.scanStartedAtInMicros = scanStartedAtInMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHeadsAndForkPoints build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHeadsAndForkPoints(null, this.heads.build(), this.forkPoints.build(), this.scanStartedAtInMicros);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scanStartedAtInMicros");
            }
            return "Cannot build HeadsAndForkPoints, some of required attributes are not set " + attributes;
        }
    }
}

