/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class BatchSpliterator<SRC, DST>
extends Spliterators.AbstractSpliterator<DST> {
    private final Spliterator<SRC> source;
    private final int batchSize;
    private List<SRC> batch;
    private final Function<List<SRC>, Spliterator<DST>> batchMapper;
    private SRC nextSource;
    private boolean sourceEof;
    private DST nextMapped;
    private boolean mappedEof;
    private Spliterator<DST> mapped = Spliterators.emptySpliterator();

    private void setNextSource(SRC nextSource) {
        this.nextSource = nextSource;
    }

    private void setNextMapped(DST nextMapped) {
        this.nextMapped = nextMapped;
    }

    public BatchSpliterator(int batchSize, Stream<SRC> source, Function<List<SRC>, Spliterator<DST>> batchMapper, int characteristics) {
        this(batchSize, source.spliterator(), batchMapper, characteristics);
    }

    public BatchSpliterator(int batchSize, Spliterator<SRC> source, Function<List<SRC>, Spliterator<DST>> batchMapper, int characteristics) {
        super(Long.MAX_VALUE, characteristics);
        this.batchSize = batchSize;
        this.batch = new ArrayList<SRC>();
        this.source = source;
        this.batchMapper = batchMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super DST> action) {
        while (true) {
            if (this.nextMapped != null) {
                try {
                    action.accept(this.nextMapped);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.nextMapped = null;
                }
            }
            if (!this.mappedEof && !this.mapped.tryAdvance(this::setNextMapped)) {
                this.mappedEof = true;
            }
            if (this.nextMapped != null) continue;
            if (this.sourceEof) {
                return false;
            }
            do {
                if (!this.source.tryAdvance(this::setNextSource)) {
                    this.sourceEof = true;
                }
                if (this.nextSource == null) continue;
                this.batch.add(this.nextSource);
                this.nextSource = null;
            } while (this.batch.size() != this.batchSize && !this.sourceEof);
            this.mappedEof = false;
            try {
                this.mapped = this.batch.isEmpty() ? Spliterators.emptySpliterator() : this.batchMapper.apply(this.batch);
                continue;
            }
            finally {
                this.batch = new ArrayList<SRC>(this.batchSize);
                continue;
            }
            break;
        }
    }
}

