/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.io.Closeable;

public final class Traced
implements Closeable {
    private final Span span;
    private final Scope scope;

    public static Traced trace(String opName) {
        return new Traced(opName);
    }

    private Traced(String opName) {
        Tracer t = GlobalTracer.get();
        String spanName = "DatabaseAdapter." + opName;
        this.span = t.buildSpan(spanName).asChildOf(t.activeSpan()).withTag(Traced.tagName("operation"), opName).start();
        this.scope = t.activateSpan(this.span);
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.finish();
    }

    public Traced tag(String tag, Number number) {
        this.span.setTag(Traced.tagName(tag), number);
        return this;
    }

    public Traced tag(String tag, String value) {
        this.span.setTag(Traced.tagName(tag), value);
        return this;
    }

    private static String tagName(String tag) {
        return "nessie.database-adapter." + tag;
    }
}

