/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.RepoDescription;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepoDescription", generator="Immutables")
@Immutable
public final class ImmutableRepoDescription
implements RepoDescription {
    private final int repoVersion;
    private final ImmutableMap<String, String> properties;

    private ImmutableRepoDescription(int repoVersion, ImmutableMap<String, String> properties) {
        this.repoVersion = repoVersion;
        this.properties = properties;
    }

    @Override
    public int getRepoVersion() {
        return this.repoVersion;
    }

    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public final ImmutableRepoDescription withRepoVersion(int value) {
        if (this.repoVersion == value) {
            return this;
        }
        return new ImmutableRepoDescription(value, this.properties);
    }

    public final ImmutableRepoDescription withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRepoDescription(this.repoVersion, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepoDescription && this.equalTo(0, (ImmutableRepoDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepoDescription another) {
        return this.repoVersion == another.repoVersion && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repoVersion;
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepoDescription").omitNullValues().add("repoVersion", this.repoVersion).add("properties", this.properties).toString();
    }

    public static ImmutableRepoDescription copyOf(RepoDescription instance) {
        if (instance instanceof ImmutableRepoDescription) {
            return (ImmutableRepoDescription)instance;
        }
        return ImmutableRepoDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepoDescription", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO_VERSION = 1L;
        private long initBits = 1L;
        private int repoVersion;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepoDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.repoVersion(instance.getRepoVersion());
            this.putAllProperties(instance.getProperties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoVersion(int repoVersion) {
            this.repoVersion = repoVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            this.properties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            this.properties.putAll(entries);
            return this;
        }

        public ImmutableRepoDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepoDescription(this.repoVersion, this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repoVersion");
            }
            return "Cannot build RepoDescription, some of required attributes are not set " + attributes;
        }
    }
}

