/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.events;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.OperationType;
import org.projectnessie.versioned.persist.adapter.events.RepositoryErasedEvent;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryErasedEvent", generator="Immutables")
@Immutable
public final class ImmutableRepositoryErasedEvent
implements RepositoryErasedEvent {
    private final long eventTimeMicros;
    private final OperationType operationType;

    private ImmutableRepositoryErasedEvent(Builder builder) {
        this.eventTimeMicros = builder.eventTimeMicros;
        this.operationType = builder.operationType != null ? builder.operationType : Objects.requireNonNull(RepositoryErasedEvent.super.getOperationType(), "operationType");
    }

    private ImmutableRepositoryErasedEvent(long eventTimeMicros, OperationType operationType) {
        this.eventTimeMicros = eventTimeMicros;
        this.operationType = operationType;
    }

    @Override
    public long getEventTimeMicros() {
        return this.eventTimeMicros;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public final ImmutableRepositoryErasedEvent withEventTimeMicros(long value) {
        if (this.eventTimeMicros == value) {
            return this;
        }
        return new ImmutableRepositoryErasedEvent(value, this.operationType);
    }

    public final ImmutableRepositoryErasedEvent withOperationType(OperationType value) {
        OperationType newValue = Objects.requireNonNull(value, "operationType");
        if (this.operationType == newValue) {
            return this;
        }
        return new ImmutableRepositoryErasedEvent(this.eventTimeMicros, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryErasedEvent && this.equalTo(0, (ImmutableRepositoryErasedEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryErasedEvent another) {
        return this.eventTimeMicros == another.eventTimeMicros && this.operationType.equals((Object)another.operationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.eventTimeMicros);
        h += (h << 5) + this.operationType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepositoryErasedEvent").omitNullValues().add("eventTimeMicros", this.eventTimeMicros).add("operationType", (Object)this.operationType).toString();
    }

    public static ImmutableRepositoryErasedEvent copyOf(RepositoryErasedEvent instance) {
        if (instance instanceof ImmutableRepositoryErasedEvent) {
            return (ImmutableRepositoryErasedEvent)instance;
        }
        return ImmutableRepositoryErasedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryErasedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RepositoryErasedEvent.Builder {
        private static final long INIT_BIT_EVENT_TIME_MICROS = 1L;
        private long initBits = 1L;
        private long eventTimeMicros;
        @Nullable
        private OperationType operationType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryErasedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdapterEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            AdapterEvent instance;
            long bits = 0L;
            if (object instanceof RepositoryErasedEvent) {
                instance = (RepositoryErasedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 2L;
                }
            }
            if (object instanceof AdapterEvent) {
                instance = (AdapterEvent)object;
                if ((bits & 1L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 2L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder eventTimeMicros(long eventTimeMicros) {
            this.eventTimeMicros = eventTimeMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder operationType(OperationType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
            return this;
        }

        @Override
        public ImmutableRepositoryErasedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryErasedEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventTimeMicros");
            }
            return "Cannot build RepositoryErasedEvent, some of required attributes are not set " + attributes;
        }
    }
}

