/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.Object2IntHashMap;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;

final class FetchValuesUsingOpenAddressing {
    final int[] keyListSegmentOffsets;
    final int keyListCount;
    final int openAddressingMask;
    final KeyListEntry[][] keyListsArray;
    final Object2IntHashMap<Hash> entityIdToSegment;
    final List<Hash> keyListIds;

    FetchValuesUsingOpenAddressing(CommitLogEntry entry) {
        List<Integer> keyListSegmentOffsetsList = entry.getKeyListEntityOffsets();
        this.keyListSegmentOffsets = keyListSegmentOffsetsList != null ? keyListSegmentOffsetsList.stream().mapToInt(Integer::intValue).toArray() : new int[]{};
        this.keyListCount = 1 + this.keyListSegmentOffsets.length;
        this.keyListsArray = new KeyListEntry[this.keyListCount][];
        this.keyListsArray[0] = entry.getKeyList().getKeys().toArray(new KeyListEntry[0]);
        this.entityIdToSegment = new Object2IntHashMap(this.keyListCount, 0.65f, -1);
        this.openAddressingMask = entry.getKeyListBucketCount() - 1;
        this.keyListIds = entry.getKeyListsIds();
    }

    int bucketForKey(ContentKey key) {
        return key.hashCode() & this.openAddressingMask;
    }

    @VisibleForTesting
    int segmentForKey(int bucket, int round) {
        int binIdx = Arrays.binarySearch(this.keyListSegmentOffsets, bucket);
        int segment = binIdx >= 0 ? binIdx + 1 : -binIdx - 1;
        return (segment + round) % this.keyListsArray.length;
    }

    List<Hash> entityIdsToFetch(int round, int prefetchEntities, Collection<ContentKey> remainingKeys) {
        Preconditions.checkArgument((0 <= prefetchEntities ? 1 : 0) != 0, (String)"Key-list segment prefetch parameter %s cannot be negative", (int)prefetchEntities);
        prefetchEntities = Math.min(prefetchEntities, this.keyListCount - 1);
        ArrayList<Hash> entitiesToFetch = new ArrayList<Hash>();
        block0: for (ContentKey key : remainingKeys) {
            int keyBucket = this.bucketForKey(key);
            int segment = this.segmentForKey(keyBucket, round);
            int prefetch = 0;
            while (true) {
                int entitySegment;
                Hash entityId;
                if (segment > 0 && this.entityIdToSegment.put((Object)(entityId = this.keyListIds.get(entitySegment = segment - 1)), segment) == -1) {
                    entitiesToFetch.add(entityId);
                }
                if (prefetch >= prefetchEntities) continue block0;
                if (++segment == this.keyListCount) {
                    segment = 0;
                }
                ++prefetch;
            }
        }
        return entitiesToFetch;
    }

    void entityLoaded(KeyListEntity keyListEntity) {
        Integer index = this.entityIdToSegment.get((Object)keyListEntity.getId());
        this.keyListsArray[index.intValue()] = keyListEntity.getKeys().getKeys().toArray(new KeyListEntry[0]);
    }

    Collection<ContentKey> checkForKeys(int round, Collection<ContentKey> remainingKeys, Consumer<KeyListEntry> resultConsumer) {
        ArrayList<ContentKey> keysForNextRound = new ArrayList<ContentKey>();
        if (this.keyListsArray.length < round) {
            return keysForNextRound;
        }
        block0: for (ContentKey key : remainingKeys) {
            int keyBucket = this.bucketForKey(key);
            int segment = this.segmentForKey(keyBucket, round);
            int offsetInSegment = 0;
            if (round == 0) {
                offsetInSegment = keyBucket;
                if (segment > 0) {
                    offsetInSegment -= this.keyListSegmentOffsets[segment - 1];
                }
            }
            KeyListEntry[] keys = this.keyListsArray[segment];
            int i = offsetInSegment;
            while (true) {
                KeyListEntry keyListEntry;
                KeyListEntry keyListEntry2 = keyListEntry = i < keys.length ? keys[i] : null;
                if (keyListEntry == null) {
                    if (keys.length != 0 || segment != 0) continue block0;
                    keysForNextRound.add(key);
                    continue block0;
                }
                if (keyListEntry.getKey().equals(key)) {
                    resultConsumer.accept(keyListEntry);
                    continue block0;
                }
                if (i == keys.length - 1) {
                    keysForNextRound.add(key);
                    continue block0;
                }
                ++i;
            }
        }
        return keysForNextRound;
    }
}

