/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.dynamodb.DefaultDynamoClientConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultDynamoClientConfig", generator="Immutables")
@Immutable
public final class ImmutableDefaultDynamoClientConfig
implements DefaultDynamoClientConfig {
    @jakarta.annotation.Nullable
    private final String endpointURI;
    @jakarta.annotation.Nullable
    private final String region;
    @jakarta.annotation.Nullable
    private final AwsCredentialsProvider credentialsProvider;
    @jakarta.annotation.Nullable
    private final DynamoDbClient dynamoDbClient;

    private ImmutableDefaultDynamoClientConfig(@jakarta.annotation.Nullable String endpointURI, @jakarta.annotation.Nullable String region, @jakarta.annotation.Nullable AwsCredentialsProvider credentialsProvider, @jakarta.annotation.Nullable DynamoDbClient dynamoDbClient) {
        this.endpointURI = endpointURI;
        this.region = region;
        this.credentialsProvider = credentialsProvider;
        this.dynamoDbClient = dynamoDbClient;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getEndpointURI() {
        return this.endpointURI;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRegion() {
        return this.region;
    }

    @Override
    @jakarta.annotation.Nullable
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    @jakarta.annotation.Nullable
    public DynamoDbClient getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public final ImmutableDefaultDynamoClientConfig withEndpointURI(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.endpointURI, value)) {
            return this;
        }
        return new ImmutableDefaultDynamoClientConfig(value, this.region, this.credentialsProvider, this.dynamoDbClient);
    }

    @Override
    public final ImmutableDefaultDynamoClientConfig withRegion(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.region, value)) {
            return this;
        }
        return new ImmutableDefaultDynamoClientConfig(this.endpointURI, value, this.credentialsProvider, this.dynamoDbClient);
    }

    @Override
    public final ImmutableDefaultDynamoClientConfig withCredentialsProvider(@jakarta.annotation.Nullable AwsCredentialsProvider value) {
        if (this.credentialsProvider == value) {
            return this;
        }
        return new ImmutableDefaultDynamoClientConfig(this.endpointURI, this.region, value, this.dynamoDbClient);
    }

    @Override
    public final ImmutableDefaultDynamoClientConfig withDynamoDbClient(@jakarta.annotation.Nullable DynamoDbClient value) {
        if (this.dynamoDbClient == value) {
            return this;
        }
        return new ImmutableDefaultDynamoClientConfig(this.endpointURI, this.region, this.credentialsProvider, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultDynamoClientConfig && this.equalTo(0, (ImmutableDefaultDynamoClientConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultDynamoClientConfig another) {
        return Objects.equals(this.endpointURI, another.endpointURI) && Objects.equals(this.region, another.region) && Objects.equals(this.credentialsProvider, another.credentialsProvider) && Objects.equals(this.dynamoDbClient, another.dynamoDbClient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.endpointURI);
        h += (h << 5) + Objects.hashCode(this.region);
        h += (h << 5) + Objects.hashCode(this.credentialsProvider);
        h += (h << 5) + Objects.hashCode(this.dynamoDbClient);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultDynamoClientConfig").omitNullValues().add("endpointURI", (Object)this.endpointURI).add("region", (Object)this.region).add("credentialsProvider", (Object)this.credentialsProvider).add("dynamoDbClient", (Object)this.dynamoDbClient).toString();
    }

    public static ImmutableDefaultDynamoClientConfig copyOf(DefaultDynamoClientConfig instance) {
        if (instance instanceof ImmutableDefaultDynamoClientConfig) {
            return (ImmutableDefaultDynamoClientConfig)instance;
        }
        return ImmutableDefaultDynamoClientConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultDynamoClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String endpointURI;
        @Nullable
        private String region;
        @Nullable
        private AwsCredentialsProvider credentialsProvider;
        @Nullable
        private DynamoDbClient dynamoDbClient;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultDynamoClientConfig instance) {
            DynamoDbClient dynamoDbClientValue;
            AwsCredentialsProvider credentialsProviderValue;
            String regionValue;
            Objects.requireNonNull(instance, "instance");
            String endpointURIValue = instance.getEndpointURI();
            if (endpointURIValue != null) {
                this.endpointURI(endpointURIValue);
            }
            if ((regionValue = instance.getRegion()) != null) {
                this.region(regionValue);
            }
            if ((credentialsProviderValue = instance.getCredentialsProvider()) != null) {
                this.credentialsProvider(credentialsProviderValue);
            }
            if ((dynamoDbClientValue = instance.getDynamoDbClient()) != null) {
                this.dynamoDbClient(dynamoDbClientValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endpointURI(@jakarta.annotation.Nullable String endpointURI) {
            this.endpointURI = endpointURI;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(@jakarta.annotation.Nullable String region) {
            this.region = region;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentialsProvider(@jakarta.annotation.Nullable AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dynamoDbClient(@jakarta.annotation.Nullable DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = dynamoDbClient;
            return this;
        }

        public ImmutableDefaultDynamoClientConfig build() {
            return new ImmutableDefaultDynamoClientConfig(this.endpointURI, this.region, this.credentialsProvider, this.dynamoDbClient);
        }
    }
}

